<?php

//use Abivia\Ledger\Messages\Report;
use App\Exports\BalanceExport;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\AgentController;
use App\Http\Controllers\AuditController;
use App\Http\Controllers\BalanceController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\JournalController;
use App\Http\Controllers\LedgerController;
use App\Http\Controllers\PartnerApiController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\RulesController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ShortCutController;
use App\Http\Controllers\StatementController;
use App\Http\Controllers\TemplatesController;
use App\Http\Controllers\TransferController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\User\UserManagement;
use Illuminate\Support\Facades\Route;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\NewsController;

// maps
Route::get('/maps/leaflet', [TransferController::class, 'AddLedger'])->name('maps-leaflet');
Route::get("ggggggg", [TransferController::class, 'AddLedger']);
// laravel example

Route::domain("transfer.com")->group(function () {

  // ROOT ROUTE - Simple redirect to dashboard (Fortify will handle auth)
  Route::get('/', function () {
    return redirect()->route('dashboard');
  })->name('home');

  // AUTHENTICATED ROUTES
  Route::middleware([
    'auth:sanctum',
    'web',
    //      'verified',
    'force.2fa.setup',
    '2fa'
  ])->group(function () {
    // Add this route to your web.php file
    Route::get('/audit-logs', [AuditController::class, 'index'])->name('audit-logs');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::get('/two-factor/setup', function () {
      return view('auth.two-factor-setup');
    })->name('two-factor.setup');

    Route::get('/export/balances', function () {
      return Excel::download(new BalanceExport, 'balances.xlsx');
    })->name('balances.export');

    Route::get('User/user-management', [UserManagement::class, 'UserManagement'])->name('user-management');
    Route::resource('user-list', UserManagement::class);

    Route::group(['prefix' => 'Accounts'], function () {
      Route::get("Search", [AccountController::class, 'Search']);
      Route::get("AgentSearch", [AgentController::class, 'AgentSearch']);
    });

    Route::resource('User', UserController::class);
    Route::resource('Settings', SettingsController::class);
    Route::resource('Agents', AgentController::class);
    Route::resource('Partners', PartnerApiController::class);
    Route::resource('Rules', RulesController::class);
    Route::resource('Templates', TemplatesController::class);
    Route::resource('Shortcuts', ShortCutController::class);
    Route::resource('Clients', ClientController::class);
    Route::resource('Transfers', TransferController::class);
    Route::resource('Currency', CurrencyController::class);
    Route::resource('Balances', BalanceController::class);
    Route::resource('Journals', JournalController::class);
    Route::resource('Report', ReportController::class);
    Route::resource('Statements', StatementController::class);
    Route::get('/transactions/data', [App\Http\Controllers\StatementController::class, 'data'])->name('transactions.data');
    Route::get('/statements/export-pdf', [App\Http\Controllers\StatementController::class, 'exportPdf'])->name('statements.export-pdf');
    Route::resource("Roles", RoleController::class);

    // Transfer Profit routes
    Route::group(['prefix' => 'transfer-profit'], function () {
      Route::get('/', [App\Http\Controllers\TransferProfitController::class, 'index'])->name('transfer-profit.index');
      Route::post('/transfer', [App\Http\Controllers\TransferProfitController::class, 'transfer'])->name('transfer-profit.transfer');
    });

    Route::group(['prefix' => 'Agent'], function () {
      Route::get("Users/{agent_id?}", [UserController::class, 'AgentUsers'])->name('users.agent');
      Route::get("Branches/{id?}", [AgentController::class, 'Branches'])->name('agents.branches');
      Route::get("CreditLimits", [AgentController::class, 'CreditLimits'])->name('agents.credit-limits');
      Route::get("Deleted", [AgentController::class, 'Deleted'])->name('agents.deleted');
      Route::get("SypRates", [AgentController::class, "AgentSypRates"]);
      Route::get("{type?}", [AgentController::class, 'index']);
    });
    Route::get("Users/{agent_id?}", [UserController::class, 'index'])->name('users.index');
    // API route for agent balances
    Route::get("api/agent/{id}/balances", [AgentController::class, 'getBalances'])->name('api.agent.balances');

    Route::get("Agentsearch/Search", [AgentController::class, 'Search']);

    // Demo route for floating action button
    Route::get('/demo/floating-action', function () {
      return view('demo.floating-action-demo');
    })->name('demo.floating-action');

    // Test route for floating action button
    Route::get('/test-floating-button', function () {
      return view('test-floating-button');
    })->name('test-floating-button');

    // Simple test route for floating button
    Route::get('/test-simple-floating', function () {
      return view('test-simple-floating');
    })->name('test-simple-floating');

    // Test route for account search
    Route::get('/test-account-search', function () {
      return view('test-account-search');
    })->name('test-account-search');

    Route::group(['prefix' => 'CreditLimits'], function () {
      Route::get("/", [AgentController::class, 'CreditLimits']);
    });

    Route::group(['prefix' => 'Client'], function () {
      Route::get("Search", [ClientController::class, 'Search']);
    });

    Route::group(['prefix' => 'Booking'], function () {
      Route::get("add/{type?}", [TransferController::class, 'AddBooking']);
      Route::get("{id}/edit", [TransferController::class, 'EditBooking']);
    });

    Route::group(['prefix' => 'Approval'], function () {
      Route::get("External", [TransferController::class, 'ExternalApproval']);
      Route::get("Internal", [TransferController::class, 'Approval']);
    });

    Route::group(['prefix' => 'Transfer'], function () {
      Route::get('/AdvancedSearch', [TransferController::class, "AdvancedSearch"]);
      Route::get('/Livewatch', [TransferController::class, "Livewatch"]);
      Route::get('/Delivered', [TransferController::class, "Delivered"]);
      Route::get('/Undelivered', [TransferController::class, 'Undelivered']);
      Route::get("/OutTransfers/{sender_id}", [TransferController::class, 'AdministratorOutTransfers'])->name('transfers.OutTransfers');
      Route::get("/InTransfers/{receiver_id}", [TransferController::class, 'AdministratorInTransfers'])->name('transfers.InTransfers');
      Route::get("/BlockedTransfers", [TransferController::class, 'BlockedTransfers'])->name('transfers.BlockedTransfers');
      Route::get("/CanceledTransfers", [TransferController::class, 'CanceledTransfers'])->name('transfers.CanceledTransfers');
      Route::get("Search", [TransferController::class, 'Search']);
      Route::get("Approval", [TransferController::class, 'Approval']);
      Route::get("Booking/{type?}", [TransferController::class, 'Books']);
      Route::get("DeletedBooking", [TransferController::class, 'DeletedBooks']);
      Route::get("Packages", [TransferController::class, 'Packages']);
      Route::get("Exchange", [TransferController::class, 'Exchange']);
      Route::get("Exchange/Prices", [TransferController::class, 'ExchangePrices']);
      Route::get("DeliverTransfer/{id?}", [TransferController::class, 'DeliverTransfer']);
      Route::get("Exchange/Multi_currency", [TransferController::class, 'Multi_currency']);
    });

    Route::group(['prefix' => 'Currencies'], function () {
      Route::get("index_data", [CurrencyController::class, 'index_data']);
      Route::get("Currency_Positions", [CurrencyController::class, 'Currency_Positions']);
    });

    Route::group(['prefix' => 'Ledger'], function () {
      Route::get('/tree', [LedgerController::class, 'tree'])->name('ledger.tree');
    });

    Route::group(['prefix' => 'Report'], function () {
      Route::get('getData', [ReportController::class, 'getData']);
    });

    Route::get("test", [TransferController::class, 'AddLedger']);

    // Route::get('glide/{path}', function ($path) {
    //   $server = \League\Glide\ServerFactory::create([
    //     'source' => app('filesystem')->disk('public')->getDriver(),
    //     'cache' => storage_path('glide'),
    //   ]);
    //   return $server->getImageResponse($path, Input::query());
    // })->where('path', '.+');
    Route::resource('news', NewsController::class);
    Route::patch('news/{news}/toggle-status', [NewsController::class, 'toggleStatus'])->name('news.toggle-status');
    // Transfer Validation Demo Routes
    Route::group(['prefix' => 'demo/transfer-validation'], function () {
      Route::get('/', [App\Http\Controllers\Demo\TransferValidationController::class, 'showDemo'])->name('demo.transfer-validation');
      Route::post('/validate', [App\Http\Controllers\Demo\TransferValidationController::class, 'processDemo'])->name('demo.transfer-validation.process');
      Route::post('/validate-beneficiary', [App\Http\Controllers\Demo\TransferValidationController::class, 'validateBeneficiaryName'])->name('demo.transfer-validation.beneficiary');
      Route::post('/validate-phone', [App\Http\Controllers\Demo\TransferValidationController::class, 'validatePhoneNumber'])->name('demo.transfer-validation.phone');
      Route::get('/settings', [App\Http\Controllers\Demo\TransferValidationController::class, 'getSettings'])->name('demo.transfer-validation.settings');
    });

    // Trial Balance Routes
    Route::group(['prefix' => 'trial-balance'], function () {
      Route::get('/', [App\Http\Controllers\TrialBalanceController::class, 'index'])->name('trial-balance.index');
      Route::get('/test', function () {
        return view('trial-balance.debug');
      })->name('trial-balance.debug');
      Route::post('/get', [App\Http\Controllers\TrialBalanceController::class, 'getTrialBalance'])->name('trial-balance.get');
      Route::get('/export', [App\Http\Controllers\TrialBalanceController::class, 'export'])->name('trial-balance.export');
      Route::post('/account-details', [App\Http\Controllers\TrialBalanceController::class, 'getAccountDetails'])->name('trial-balance.account-details');
    });

    Route::group(['prefix' => 'Roles'], function () {
      Route::get("edit/{id}", [RoleController::class, 'edit']);
    });

    Route::get('/media/download/{media}', function ($media) {
      // Optional: check access to parent model
      $model = $media->model; // This is the parent model (e.g. User, Post, etc.)

      if (!\Illuminate\Support\Facades\Auth::check()) {
        abort(403);
      }

      return $media;
    })->name('media.download');
  });
});

// News Routes
