@extends('layouts.layoutMaster')

@section('title', 'إضافة خبر جديد')

@section('content')
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">إضافة خبر جديد</h4>
                        <a href="{{ route('news.index') }}" class="btn btn-secondary">
                            <i class="bx bx-arrow-back me-1"></i>العودة
                        </a>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('news.store') }}" method="POST">
                            @csrf

                            <div class="mb-3">
                                <label for="content" class="form-label">محتوى الخبر <span
                                        class="text-danger">*</span></label>
                                <textarea name="content" id="content" rows="6" class="form-control @error('content') is-invalid @enderror"
                                    placeholder="اكتب محتوى الخبر هنا..." required>{{ old('content') }}</textarea>
                                @error('content')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                                <div class="form-text">يجب أن يكون المحتوى 10 أحرف على الأقل</div>
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input type="checkbox" name="is_active" id="is_active" class="form-check-input"
                                        value="1" {{ old('is_active') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        تفعيل الخبر
                                    </label>
                                </div>
                                <div class="form-text">الخبر المفعل سيظهر للمستخدمين</div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bx bx-save me-1"></i>حفظ الخبر
                                </button>
                                <a href="{{ route('news.index') }}" class="btn btn-light">
                                    إلغاء
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
