<div>
    <div class="row mb-4 g-4">
        <!-- Total Rent Paid -->
        <div class="col-sm-6 col-xl-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                            <h5 class="mb-1">{{ PriceFormat($statistics['total_rent_paid']) }}</h5>
                            <small class="text-muted">{{ __('user.total_rent_paid') }}</small>
                        </div>
                        <span class="badge bg-label-success rounded-circle p-2">
                            <i class="ti ti-wallet ti-lg"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Outstanding Balance -->
        <div class="col-sm-6 col-xl-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                            <h5 class="mb-1">{{ PriceFormat($statistics['outstanding_balance']) }}</h5>
                            <small class="text-muted">{{ __('user.outstanding_balance') }}</small>
                        </div>
                        <span class="badge bg-label-warning rounded-circle p-2">
                            <i class="ti ti-credit-card-off ti-lg"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Next Due Date -->
        <div class="col-sm-6 col-xl-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                            <h5 class="mb-1">{{ $statistics['next_due_date'] ?? '-' }}</h5>
                            <small class="text-muted">{{ __('user.next_due_date') }}</small>
                        </div>
                        <span class="badge bg-label-primary rounded-circle p-2">
                            <i class="ti ti-calendar-clock ti-lg"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>



        <!-- Total Late Payments -->
        <div class="col-sm-6 col-xl-3">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                            <h5 class="mb-1">{{ PriceFormat($statistics['total_late_fees']) }}</h5>
                            <small class="text-muted">{{ __('user.total_late_payments') }}</small>
                        </div>
                        <span class="badge bg-label-danger rounded-circle p-2">
                            <i class="ti ti-clock-pause ti-lg"></i>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mb-4 g-6 ">
        <div class="col-xxl-6 col-lg-6 " wire:ignore>
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="mb-1">Monthly Rent Payments</h5>
                        <p class="card-subtitle"> {{ __('properties.occupancy_vs_vacancy') }}
                        </p>
                    </div>

                </div>
                <div class="card-body">
                    <div id="MonthlyRentPayments"></div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-lg-6 " wire:ignore>
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="mb-1">{{ __('properties.rental_collection_chart') }}</h5>
                        <p class="card-subtitle"> {{ __('properties.billed_vs_collected') }}
                        </p>
                    </div>

                </div>
                <div class="card-body">
                    <div id="PaidVsUnpaidChart"></div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-lg-6 " wire:ignore>
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="mb-1">{{ __('properties.top_5_income_properties') }}</h5>
                        <p class="card-subtitle"> {{ __('properties.top_5_collected_rent_properties') }}
                        </p>
                    </div>

                </div>
                <div class="card-body">
                    <ul class="timeline mb-0">
                        @foreach ($timeline as $item)
                            <li class="timeline-item timeline-item-transparent">
                                <span class="timeline-point {{ $item['point_class'] }}"></span>
                                <div class="timeline-event">
                                    <div class="timeline-header mb-3">
                                        <h6 class="mb-0">{{ $item['title'] }} ({{ $item['status'] }})</h6>
                                        <small class="text-muted">{{ $item['issue_date'] }}</small>
                                    </div>
                                    <p class="mb-2">{{ $item['description'] }}</p>
                                    @if ($item['payment_date'])
                                        <small class="text-muted">Paid on: {{ $item['payment_date'] }}</small>
                                    @endif
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-xxl-6 col-lg-6 " wire:ignore>
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="card-title mb-0">
                        <h5 class="mb-1">{{ __('properties.type_rent_chart') }}</h5>
                        <p class="card-subtitle">
                            {{ __('properties.this_chart_shows_the_distribution_of_properties_by_type_and_rent') }}.
                        </p>
                    </div>

                </div>
                <div class="card-body">
                    <div id="LeaseBreakdownChart"></div>
                </div>
            </div>
        </div>

    </div>

</div>
