<div>
    <!-- Transfer Details Modal -->
    <div class="modal fade" id="showTransferDetails" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="tf-icons ti ti-receipt me-2"></i>
                        {{ __('Transfer Details') }}
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>

                <div class="modal-body p-4">
                    @if (isset($transfer))
                        <!-- Transfer Status Badge -->
                        <div class="text-center mb-4">
                            @php
                                $statusClass = match ($transfer->status) {
                                    'completed' => 'success',
                                    'pending' => 'warning',
                                    'cancelled' => 'danger',
                                    'blocked' => 'secondary',
                                    default => 'info',
                                };
                            @endphp
                            <span class="badge bg-{{ $statusClass }} fs-6 px-3 py-2">
                                <i class="tf-icons ti ti-circle-check me-1"></i>
                                {{ __($transfer->status) }}
                            </span>
                        </div>

                        <div class="row g-4">
                            <!-- Basic Information -->
                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0">
                                            <i class="tf-icons ti ti-info-circle me-2 text-primary"></i>
                                            {{ __('Basic Information') }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">
                                            <div class="col-6">
                                                <label class="form-label text-muted small">{{ __('Reference') }}</label>
                                                <div class="fw-bold">{{ $transfer->reference }}</div>
                                            </div>
                                            <div class="col-6">
                                                <label
                                                    class="form-label text-muted small">{{ __('Secret Code') }}</label>
                                                <div class="fw-bold">{{ $transfer->secret }}</div>
                                            </div>
                                            <div class="col-6">
                                                <label class="form-label text-muted small">{{ __('Amount') }}</label>
                                                <div class="fw-bold text-success fs-5">
                                                    {!! PriceFormat($transfer->amount, $transfer->currency) !!}
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label
                                                    class="form-label text-muted small">{{ __('Delivery Amount') }}</label>
                                                <div class="fw-bold text-info fs-5">
                                                    {!! PriceFormat($transfer->delivery_amount, $transfer->delivery_currency) !!}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Fees Information -->
                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0">
                                            <i class="tf-icons ti ti-coin me-2 text-warning"></i>
                                            {{ __('Fees & Charges') }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">
                                            <div class="col-6">
                                                <label
                                                    class="form-label text-muted small">{{ __('Sender Fee') }}</label>
                                                <div class="fw-bold text-danger">
                                                    {!! PriceFormat($transfer->sender_fee, $transfer->currency) !!}

                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label
                                                    class="form-label text-muted small">{{ __('Receiver Fee') }}</label>
                                                <div class="fw-bold text-danger">
                                                    {!! PriceFormat($transfer->receiver_fee, $transfer->delivery_currency) !!}

                                                </div>
                                            </div>

                                            <div class="col-6">
                                                <label
                                                    class="form-label text-muted small">{{ __('Exchange Rate') }}</label>
                                                <div class="fw-bold text-primary">
                                                    {{ number_format($transfer->rate, 4) }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Sender Information -->
                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0">
                                            <i class="tf-icons ti ti-user me-2 text-success"></i>
                                            {{ __('Sender Information') }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="avatar avatar-sm me-3">
                                                <span class="avatar-initial rounded-circle bg-success">
                                                    <i class="tf-icons ti ti-user"></i>
                                                </span>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $transfer->sender->name ?? 'N/A' }}</h6>
                                                <small
                                                    class="text-muted">{{ $transfer->sender->phone ?? 'N/A' }}</small>
                                            </div>
                                        </div>
                                        @if ($transfer->sender->address)
                                            <div class="text-muted small">
                                                <i class="tf-icons ti ti-map-pin me-1"></i>
                                                {{ $transfer->sender->address->full_address ?? 'N/A' }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <!-- Receiver Information -->
                            <div class="col-md-6">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0">
                                            <i class="tf-icons ti ti-user-check me-2 text-info"></i>
                                            {{ __('Receiver Information') }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="avatar avatar-sm me-3">
                                                <span class="avatar-initial rounded-circle bg-info">
                                                    <i class="tf-icons ti ti-user-check"></i>
                                                </span>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $transfer->recipient_name ?? 'N/A' }}</h6>
                                                <small
                                                    class="text-muted">{{ $transfer->recipient_phone ?? 'N/A' }}</small>
                                            </div>
                                        </div>
                                        @if ($transfer->address)
                                            <div class="text-muted small">
                                                <i class="tf-icons ti ti-map-pin me-1"></i>
                                                {{ $transfer->address->full_address ?? 'N/A' }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <!-- Transfer Details -->
                            <div class="col-12">
                                <div class="card border-0 shadow-sm">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0">
                                            <i class="tf-icons ti ti-calendar me-2 text-primary"></i>
                                            {{ __('Transfer Details') }}
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">

                                            <div class="col-md-4">
                                                <label
                                                    class="form-label text-muted small">{{ __('Created At') }}</label>
                                                <div class="fw-bold">
                                                    {{ $transfer->created_at ? \Carbon\Carbon::parse($transfer->created_at)->format('d/m/Y H:i') : 'N/A' }}
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label
                                                    class="form-label text-muted small">{{ __('Delivered At') }}</label>
                                                <div class="fw-bold">
                                                    {{ $transfer->delivered_at ? \Carbon\Carbon::parse($transfer->delivered_at)->format('d/m/Y H:i') : 'N/A' }}
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label text-muted small">{{ __('Type') }}</label>
                                                <div class="fw-bold">
                                                    <span class="badge bg-secondary">{{ __($transfer->type) }}</span>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label text-muted small">{{ __('Notes') }}</label>
                                                <div class="fw-bold">
                                                    <span class="badge bg-secondary">{{ __($transfer->note) }}</span>
                                                </div>
                                            </div>

                                        </div>

                                        @if ($transfer->note)
                                            <div class="mt-3">
                                                <label class="form-label text-muted small">{{ __('Notes') }}</label>
                                                <div class="fw-bold p-3 bg-light rounded">
                                                    {{ $transfer->note }}
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row g-3">
                                        <!-- Client Details -->
                                        <div class="col-md-6">
                                            <div class="card border-0 shadow-sm">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0">
                                                        <i class="tf-icons ti ti-user me-2 text-success"></i>
                                                        {{ __('Client Details') }}
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    @if ($transfer->client)
                                                        <div class="d-flex align-items-center mb-3">
                                                            <div class="avatar avatar-sm me-3">
                                                                <span class="avatar-initial rounded-circle bg-success">
                                                                    <i class="tf-icons ti ti-user"></i>
                                                                </span>
                                                            </div>
                                                            <div>
                                                                <h6 class="mb-0">
                                                                    {{ $transfer->client->name ?? 'N/A' }}
                                                                </h6>
                                                                <small
                                                                    class="text-muted">{{ $transfer->client->phone ?? 'N/A' }}</small>
                                                            </div>
                                                        </div>
                                                        @if ($transfer->client->address)
                                                            <div class="text-muted small mb-2">
                                                                <i class="tf-icons ti ti-map-pin me-1"></i>
                                                                {{ $transfer->client->address->full_address ?? 'N/A' }}
                                                            </div>
                                                        @endif
                                                        @if ($transfer->client->identity_number)
                                                            <div class="text-muted small">
                                                                <i class="tf-icons ti ti-id me-1"></i>
                                                                {{ __('ID Number') }}:
                                                                {{ $transfer->client->identity_number }}
                                                            </div>
                                                        @endif
                                                    @else
                                                        <div class="text-center text-muted py-3">
                                                            <i class="tf-icons ti ti-user-off"
                                                                style="font-size: 2rem;"></i>
                                                            <p class="mb-0 mt-2">
                                                                {{ __('No client information available') }}</p>
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Recipient Details -->
                                        <div class="col-md-6">
                                            <div class="card border-0 shadow-sm">
                                                <div class="card-header bg-light">
                                                    <h6 class="mb-0">
                                                        <i class="tf-icons ti ti-user-check me-2 text-info"></i>
                                                        {{ __('Recipient Details') }}
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center mb-3">
                                                        <div class="avatar avatar-sm me-3">
                                                            <span class="avatar-initial rounded-circle bg-info">
                                                                <i class="tf-icons ti ti-user-check"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0">
                                                                {{ $transfer->recipient_name ?? 'N/A' }}
                                                            </h6>
                                                            <small
                                                                class="text-muted">{{ $transfer->recipient_phone ?? 'N/A' }}</small>
                                                        </div>
                                                    </div>

                                                    @if ($transfer->recipient_identity_number)
                                                        <div class="text-muted small mb-2">
                                                            <i class="tf-icons ti ti-id me-1"></i>
                                                            {{ __('ID Number') }}:
                                                            {{ $transfer->recipient_identity_number }}
                                                        </div>
                                                    @endif

                                                    @if ($transfer->address)
                                                        <div class="text-muted small">
                                                            <i class="tf-icons ti ti-map-pin me-1"></i>
                                                            {{ $transfer->address->full_address ?? 'N/A' }}
                                                        </div>
                                                    @endif

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <!-- External Information (if applicable) -->
                            @if ($transfer->external_ref || $transfer->api_id)
                                <div class="col-12">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-header bg-light">
                                            <h6 class="mb-0">
                                                <i class="tf-icons ti ti-external-link me-2 text-warning"></i>
                                                {{ __('External Transfer Information') }}
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="row g-3">
                                                @if ($transfer->external_ref)
                                                    <div class="col-md-6">
                                                        <label
                                                            class="form-label text-muted small">{{ __('External Reference') }}</label>
                                                        <div class="fw-bold">{{ $transfer->external_ref }}</div>
                                                    </div>
                                                @endif
                                                @if ($transfer->api_id)
                                                    <div class="col-md-6">
                                                        <label
                                                            class="form-label text-muted small">{{ __('API ID') }}</label>
                                                        <div class="fw-bold">{{ $transfer->api_id }}</div>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="tf-icons ti ti-alert-circle text-muted" style="font-size: 3rem;"></i>
                            <h5 class="text-muted mt-3">{{ __('No Transfer Selected') }}</h5>
                            <p class="text-muted">{{ __('Please select a transfer to view details') }}</p>
                        </div>
                    @endif

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="tf-icons ti ti-x me-1"></i>
                        {{ __('Close') }}
                    </button>
                    @if (isset($transfer))
                        <button type="button" class="btn btn-primary" onclick="printTransferDetails()">
                            <i class="tf-icons ti ti-printer me-1"></i>
                            {{ __('Print') }}
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script>
        function printTransferDetails() {
            // Print functionality
            window.print();
        }
    </script>
</div>
