<div>

    <div class="row">

        <div class="col-xl-8 col-lg-8 col-md-8">
            <!-- Activity Timeline -->
            <div class="card card-action mb-4">



                <div class="card-body pb-0">
                    <div class="d-flex justify-content-start mb-2">

                        <button class="btn btn-sm btn-outline-secondary"
                            wire:click="$dispatch('openFormConfigModal', { formName: 'transfer_form' })">
                            <i class="ti ti-settings"></i> إعداد الحقول
                        </button>
                    </div>

                    <form id="transfer_form" class="card-body" wire:submit.prevent="searchSender">

                        <div class="col-md-12 select2_content">
                            <label class="form-label">
                                {{ $this->getFieldLabel('recipient.sender_identity_number') ?? __('transfers.sender_national_id') }}:
                            </label>

                            <div class="input-group w-100">

                                <div class="flex-grow-1">
                                    <x-Mulk.live_search wire:model="recipient.sender_identity_number" :search-url="$clientsSearchUrl"
                                        placeholder="{{ __('transfers.national_id_placeholder') }}" />


                                </div>
                                <button class="btn btn-outline-primary" type="button" wire:click="AddNewClientEvent">
                                    {{ __('general.add') }}
                                </button>
                            </div>
                        </div>
                    </form>
                    @if ($add_client)
                        @livewire('client.add')
                    @else
                        <form class="card-body" wire:submit.prevent="confirmTransfer">
                            <div class="row g-3">



                                {{-- Sender Agent --}}
                                <div class="col-md-12 select2_content">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <label
                                            class="form-label mb-0">{{ $this->getFieldLabel('transfer.sender_id') ?? __('transfers.sender_agent') }}</label>
                                        <div class="dropdown">
                                            <i class="ti ti-tag cursor-pointer" id="dropdownLabel1"
                                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                                style="color :red;"></i>
                                            <div class="dropdown-menu dropdown-menu-start"
                                                aria-labelledby="dropdownLabel1" style="padding: 20px;">
                                                <x-balance-badges :balances="$this->getBalances($transfer['sender_id'])" :limit="getBalanceLimit($transfer['sender_id'])"
                                                    :basebalance="getBaseCurrencyBalance(
                                                        $this->getBalances($transfer['sender_id']),
                                                    )" />
                                            </div>
                                        </div>
                                    </div>


                                    <x-Mulk.ajax-select2 wire:model.live="transfer.sender_id" searchUrl="/home"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.sender_id') }}"
                                        placeholder="Select Account"
                                        search-url="/Accounts/AgentSearch?type=transfer&direction=sender" />
                                    @if (isset($senderDetails['name']))
                                        <div class="yellow-box mt-2">
                                            {{ $senderDetails['name'] ?? '' }}
                                        </div>
                                    @endif

                                    @error('transfer.sender_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>




                                {{-- Recipient Name & Phone --}}
                                <div class="col-md-6">
                                    <label
                                        class="form-label">{{ $this->getFieldLabel('transfer.recipient_name') ?? __('transfers.recipient_name') }}</label>

                                    <input type="text" class="form-control" wire:model="transfer.recipient_name"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.recipient_name') }}" />
                                    @error('recipient.name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label
                                        class="form-label">{{ $this->getFieldLabel('transfer.recipient_phone') ?? __('transfers.recipient_phone') }}</label>
                                    <input type="text" class="form-control phone-mask"
                                        wire:model="transfer.recipient_phone"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.recipient_phone') }}" />
                                    @error('recipient.phone')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                {{-- Receiver Agent --}}
                                <div class="col-md-6 select2_content">
                                    <div class="d-flex align-items-center gap-2 mb-2">
                                        <label
                                            class="form-label mb-0">{{ $this->getFieldLabel('transfer.receiver_id') ?? __('transfers.select_receiver') }}:</label>
                                        <div class="dropdown">
                                            <i class="ti ti-tag cursor-pointer" id="dropdownLabel2"
                                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                                style="color :red;"></i>
                                            <div class="dropdown-menu dropdown-menu-start"
                                                aria-labelledby="dropdownLabel2" style="padding: 20px;">
                                                <x-balance-badges :balances="$this->getBalances($transfer['receiver_id'])" :limit="2000"
                                                    :basebalance="getBaseCurrencyBalance(
                                                        $this->getBalances($transfer['receiver_id']),
                                                    )" />
                                            </div>
                                        </div>
                                    </div>
                                    <x-Mulk.ajax-select2 wire:model.live="transfer.receiver_id" searchUrl="/home"
                                        placeholder="Select Account"
                                        search-url="/Accounts/AgentSearch?type={{ $type }}&direction=receiver"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.receiver_id') }}" />
                                    @error('transfer.receiver_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    <div class="dark-red-text text-danger" style="font-weight: bold;">
                                        {{ $receiverDetails['name'] ?? '' }}
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">{{ __('transfers.address') }}</label>
                                    <textarea class="form-control" readonly disabled>{{ $address }} </textarea>
                                </div>

                                {{-- Currencies & Amounts --}}
                                <div class="col-md-6 select2_content">
                                    <label
                                        class="form-label">{{ $this->getFieldLabel('transfer.currency') ?? __('transfers.sent_currency') }}</label>
                                    <x-Mulk.select2 wire:model="transfer.currency" class="form-select"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.currency') }}">
                                        <option value="">{{ __('general.select') }}</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </x-Mulk.select2>
                                    @error('transfer.currency')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label
                                        class="form-label">{{ $this->getFieldLabel('transfer.amount') ?? __('transfers.amount_to_send') }}</label>
                                    <input type="number" class="form-control" name="amount" placeholder="0.00"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.amount') }}" step="any"
                                        required wire:model.lazy="transfer.amount" @readonly($transfer['fee_type'] == 'included') />
                                    @if (isset($transfer['amount']))
                                        <div class="yellow-box mt-0">
                                            {{ $this->getAmountInWords($transfer['amount'], $transfer['currency']) }}
                                        </div>
                                    @endif
                                    @error('transfer.amount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6 select2_content">
                                    <label
                                        class="form-label">{{ $this->getFieldLabel('transfer.delivery_currency') ?? __('transfers.delivery_currency') }}</label>
                                    <x-Mulk.select2 wire:model.lazy="transfer.delivery_currency" class="form-select"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.delivery_currency') }}">
                                        <option value="">{{ __('general.select') }}</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </x-Mulk.select2>
                                    @error('transfer.delivery_currency')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label
                                        class="form-label">{{ $this->getFieldLabel('transfer.delivery_amount') ?? __('transfers.total_to_receive') }}</label>
                                    <input type="number" class="form-control" name="delivery_amount"
                                        placeholder="0.00" required wire:model.lazy="transfer.delivery_amount"
                                        tabindex="{{ $this->getFieldTabIndex('transfer.delivery_amount') }}"
                                        step="any" @readonly($transfer['fee_type'] == 'included') />
                                    @if (isset($transfer['delivery_amount']) && isset($transfer['delivery_currency']))
                                        <div class="yellow-box mt-2">
                                            {{ $this->getAmountInWords($transfer['delivery_amount'] ?? 0, $transfer['delivery_currency']) }}
                                        </div>
                                    @endif

                                    @error('transfer.delivery_amount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                @if ($this->fieldIsVisible('transfer.send_fee'))
                                    <div class="col-md-6">
                                        <label
                                            class="form-label">{{ $this->getFieldLabel('transfer.send_fee') ?? __('transfers.transfer_fee') }}</label>
                                        <input type="number" class="form-control" name="send_fee"
                                            model="transfer.send_fee" placeholder="0.00" required step="any"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.send_fee') }}"
                                            wire:model.lazy="transfer.send_fee" max="9999.99" @readonly($transfer['fee_type'] == 'included') />


                                        @error('transfer.send_fee')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                @endif

                                @if ($this->fieldIsVisible('transfer.receiver_fee') && 1 == 0)
                                    <div class="col-md-6">
                                        <label
                                            class="form-label">{{ $this->getFieldLabel('transfer.receiver_fee') ?? __('transfers.delivery_fee') }}</label>
                                        <x-decimal-input name="receiver_fee" model="transfer.receiver_fee"
                                            placeholder="0.00" required wire:model.live="transfer.receiver_fee"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.receiver_fee') }}"
                                            step="any" min="0.01" max="9999.99" />


                                        @error('transfer.receiver_fee')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror

                                    </div>
                                @endif

                                @if ($this->fieldIsVisible('transfer.fee_type'))
                                    <div class="col-md-6">
                                        <label
                                            class="form-label">{{ $this->getFieldLabel('transfer.fee_type') ?? __('transfers.fee_type') }}</label>
                                        <select class="form-select" wire:model.live="transfer.fee_type"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.fee_type') }}">
                                            <option value="collected">{{ __('transfers.fee_collected') }}</option>
                                            <option value="included">{{ __('transfers.fee_included') }}</option>
                                        </select>
                                    </div>
                                @endif

                                @if ($this->fieldIsVisible('transfer.exchange_rate'))
                                    <div class="col-md-3">
                                        <label
                                            class="form-label">{{ $this->getFieldLabel('transfer.exchange_rate') ?? __('transfers.exchange_rate') }}</label>
                                        <input type="number" class="form-control" step="any"
                                            wire:model.lazy="transfer.rate"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.exchange_rate') }}" />
                                    </div>
                                @endif

                                @if ($this->fieldIsVisible('transfer.rate_factor'))
                                    <div class="col-md-3">
                                        <label class="form-label"> {{ __('transfers.exchange_factor') }}</label>
                                        <select class="form-select" wire:model.live="transfer.rate_factor"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.rate_factor') }}">
                                            <option value="multiply">ضرب</option>
                                            <option value="divide">قسمة</option>
                                        </select>
                                    </div>
                                @endif

                                {{-- Notes --}}
                                @if ($this->fieldIsVisible('transfer.notes'))
                                    <div class="col-md-6">
                                        <label
                                            class="form-label">{{ $this->getFieldLabel('transfer.notes') ?? __('transfers.notes') }}</label>
                                        <input type="text" class="form-control" placeholder="ملاحظات"
                                            wire:model="transfer.notes"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.notes') }}">
                                    </div>
                                @endif

                                @if ($this->fieldIsVisible('transfer.reason_id'))
                                    <div class="col-md-6  select2_content">
                                        <label
                                            class="form-label">{{ $this->getFieldLabel('transfer.reason_id') ?? __('transfers.transfer_reason') }}</label>
                                        <x-Mulk.select2 class="form-select" wire:model="transfer.reason_id"
                                            tabindex="{{ $this->getFieldTabIndex('transfer.reason_id') }}">
                                            @foreach ($reasons as $reason)
                                                <option value="{{ $reason->id }}">{{ $reason->name }}</option>
                                            @endforeach
                                        </x-Mulk.select2>
                                    </div>
                                @endif
                            </div>
                            @if ($this->fieldIsVisible('attatchments'))
                                @livewire('components.attachments-repeater')
                            @endif
                            <br />
                            <div class="d-grid gap-2 col-6 mx-auto">
                                <button class="btn btn-primary" type="submit" wire:loading.attr="disabled">
                                    <i class="ti ti-send"></i> {{ __('transfers.send') }}
                                </button>
                            </div>

                            @error('balance')
                                <div class="text-center text-danger my-3 fw-bold">

                                    {{ $message }}
                                </div>
                            @enderror
                            @error('transfer.rate')
                                <div class="text-center text-danger my-3 fw-bold">
                                    {{ $message }}
                                </div>
                            @enderror
                            @error('currency_error')
                                <div class="text-center text-danger my-3 fw-bold">
                                    {{ $message }}
                                </div>
                            @enderror

                        </form>
                    @endif
                </div>
            </div>
            <!--/ Activity Timeline -->
        </div>


        <div class="col-xl-4 col-lg-4 col-md-4">
            @livewire('client.show-info')
        </div>
    </div>


</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Function to focus on the first visible input field
        function focusFirstVisibleField() {
            try {
                // Priority order for fields to focus on
                const priorityFields = [
                    'transfer.sender_id', // Sender dropdown
                    'recipient.sender_identity_number', // Identity number input
                    'transfer.currency', // Currency dropdown
                    'transfer.amount', // Amount input
                    'transfer.receiver_id' // Receiver dropdown
                ];

                // Try to focus on priority fields first
                for (let fieldKey of priorityFields) {
                    const field = findFieldByKey(fieldKey);
                    if (field && isFieldVisible(field)) {
                        field.focus();
                        console.log('Auto-focused on priority field:', fieldKey);
                        return;
                    }
                }

                // Fallback: focus on first visible field
                const formFields = document.querySelectorAll(
                    'input:not([type="hidden"]):not([type="file"]), select, textarea');

                for (let field of formFields) {
                    if (isFieldVisible(field)) {
                        field.focus();
                        console.log('Auto-focused on fallback field:', field.name || field.id || field
                            .placeholder);
                        break;
                    }
                }
            } catch (error) {
                console.log('Auto-focus failed:', error.message);
            }
        }

        // Helper function to find field by key
        function findFieldByKey(key) {
            // Try different selectors
            const selectors = [
                `[wire\\:model*="${key}"]`,
                `[name*="${key.replace('.', '_')}"]`,
                `[id*="${key.replace('.', '_')}"]`
            ];

            for (let selector of selectors) {
                const field = document.querySelector(selector);
                if (field) return field;
            }

            return null;
        }

        // Helper function to check if field is visible
        function isFieldVisible(field) {
            return field &&
                field.offsetParent !== null &&
                field.style.display !== 'none' &&
                field.style.visibility !== 'hidden' &&
                !field.disabled &&
                !field.readOnly;
        }

        // Focus immediately when DOM is ready
        focusFirstVisibleField();

        // Also focus when Livewire updates (for dynamic content)
        document.addEventListener('livewire:load', function() {
            // Small delay to ensure all fields are rendered
            setTimeout(focusFirstVisibleField, 100);
        });

        // Focus after any Livewire updates
        document.addEventListener('livewire:updated', function() {
            setTimeout(focusFirstVisibleField, 100);
        });

        // Focus when the modal opens (if this is in a modal)
        const modal = document.getElementById('MoneyTransferModal');
        if (modal) {
            modal.addEventListener('shown.bs.modal', function() {
                setTimeout(focusFirstVisibleField, 200);
            });
        }
    });
</script>
