<div>


    <form class="row g-6">


        <!-- Sender Section -->
        <div class="col-12 col-md-6">
            <div class="card h-100">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">{{ __('transfers.sender_details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3 select2_content">
                        <label class="form-label">{{ __('transfers.select_sender') }} <span
                                class="text-danger">*</span></label>
                        <x-Mulk.select2 wire:model="transfer.sender_id" class="select2 form-select">
                            <option value="">{{ __('general.select') }}</option>
                            @foreach ($senders as $sender)
                                <option value="{{ $sender->id }}">{{ $sender->code }} -
                                    {{ $sender->name }}</option>
                            @endforeach
                        </x-Mulk.select2>
                        @error('transfer.sender_id')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Sender Details (auto-filled when agent selected) -->
                    <div wire:loading.remove wire:target="transfer.sender_id">
                        <div class="mb-3">
                            <label class="form-label">{{ __('transfers.sender_client') }}</label>
                            <input type="text" wire:model="senderDetails.name" class="form-control" readonly />
                        </div>

                        <div class="mb-3">
                            <label class="form-label">{{ __('agents.phone') }}</label>
                            <input type="text" wire:model="senderDetails.phone" class="form-control" readonly />
                        </div>


                        <div class="mb-3 select2_content">
                            <label class="form-label">{{ __('transfers.amount_to_send') }}</label>
                            <div class="input-group">
                                <x-Mulk.select2 wire:model.defer="transfer.receiver_fee_currency" class="form-control">
                                    @foreach ($currencies as $key => $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                                <input type="number" wire:model.defer="transfer.amount" class="form-control" />
                            </div>
                            @error('transfer.amount')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>


                        <div class="mb-3 select2_content">
                            <label class="form-label">{{ __('transfers.transfer_fee') }}</label>
                            <div class="input-group">
                                <x-Mulk.select2 wire:model.defer="transfer.receiver_fee_currency" class="form-control">
                                    @foreach ($currencies as $key => $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                                <input type="number" wire:model.defer="transfer.sender_fee" class="form-control" />
                            </div>
                            @error('transfer.sender_fee')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3 select2_content">
                            <label class="form-label">سبب التحويل</label>
                            <div class="input-group">
                                <x-Mulk.select2 wire:model.defer="transfer.receiver_fee_currency" class="form-control">
                                    @foreach ($currencies as $key => $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                                <input type="number" wire:model.defer="transfer.sender_fee" class="form-control" />
                            </div>
                            @error('transfer.sender_fee')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div wire:loading wire:target="transfer.sender_id">
                        <div class="text-center py-3">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Receiver Section -->
        <div class="col-12 col-md-6">
            <div class="card h-100">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">{{ __('transfers.receiver_details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3 select2_content">
                        <label class="form-label">{{ __('transfers.select_receiver') }} <span
                                class="text-danger">*</span></label>
                        <x-Mulk.select2 wire:model="transfer.receiver_id" class="select2 form-select">
                            <option value="">{{ __('general.select') }}</option>
                            @foreach ($receivers as $receiver)
                                <option value="{{ $receiver->id }}">{{ $receiver->code }} -
                                    {{ $receiver->name }}</option>
                            @endforeach
                        </x-Mulk.select2>
                        @error('transfer.receiver_id')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Receiver Details (auto-filled when agent selected) -->
                    <div wire:loading.remove wire:target="transfer.receiver_id">
                        <div class="mb-3">
                            <label class="form-label">{{ __('transfers.receiver_client') }}</label>
                            <input type="text" wire:model="receiverDetails.name" class="form-control" readonly />
                        </div>

                        <div class="mb-3">
                            <label class="form-label">{{ __('agents.phone') }}</label>
                            <input type="text" wire:model="receiverDetails.phone" class="form-control" readonly />
                        </div>

                        <div class="mb-3 select2_content">
                            <label class="form-label">{{ __('transfers.total_to_receive') }}
                            </label>
                            <div class="input-group">
                                <x-Mulk.select2 wire:model.defer="transfer.receiver_fee_currency" class="form-control">
                                    @foreach ($currencies as $key => $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                                <input type="text" wire:model="totalToReceive" class="form-control" />
                            </div>
                        </div>


                        <div class="mb-3 select2_content">
                            <label class="form-label">{{ __('transfers.transfer_fee') }}</label>
                            <div class="input-group">
                                <x-Mulk.select2 wire:model.defer="transfer.receiver_fee_currency" class="form-control">
                                    @foreach ($currencies as $key => $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                                <input type="number" wire:model.defer="transfer.sender_fee" class="form-control" />
                            </div>
                            @error('transfer.sender_fee')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3 select2_content">
                            <label class="form-label">الصرف</label>
                            <div class="input-group">
                                <x-Mulk.select2 wire:model.defer="transfer.receiver_fee_currency"
                                    class="form-control">
                                    @foreach ($currencies as $key => $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                                <input type="number" wire:model.defer="transfer.sender_fee" class="form-control" />
                            </div>
                            @error('transfer.sender_fee')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>
                    <div wire:loading wire:target="transfer.receiver_id">
                        <div class="text-center py-3">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Section -->
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">{{ __('transfers.transfer_summary') }}</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-borderless mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('transfers.transfer_amount') }}</th>
                                    <th>{{ __('transfers.sender_fee') }}</th>
                                    <th>{{ __('transfers.receiver_fee') }}</th>
                                    <th>{{ __('transfers.debit') }}</th>
                                    <th>{{ __('transfers.credit') }}</th>
                                    <th>{{ __('transfers.revenue') }}</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class="fw-semibold">
                                        {{ $transfer['currency'] ?? 'USD' }}
                                        {{ number_format($transfer['amount'] ?? 0, 2) }}
                                    </td>
                                    <td class="fw-semibold">
                                        {{ $transfer['currency'] ?? 'USD' }}
                                        {{ number_format($transfer['sender_fee'] ?? 0, 2) }}
                                    </td>
                                    <td class="fw-semibold">
                                        {{ $transfer['currency'] ?? 'USD' }}
                                        {{ number_format($transfer['receiver_fee'] ?? 0, 2) }}
                                    </td>
                                    <td class="fw-semibold">
                                        {{ $transfer['currency'] ?? 'USD' }}
                                        {{ number_format($debit ?? 0, 2) }}
                                    </td>
                                    <td class="fw-semibold">
                                        {{ $transfer['currency'] ?? 'USD' }}
                                        {{ number_format($credit ?? 0, 2) }}
                                    </td>
                                    <td class="fw-semibold">
                                        {{ $transfer['currency'] ?? 'USD' }}
                                        {{ number_format($revenue ?? 0, 2) }}
                                    </td>

                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="col-12 text-center mt-4">
            <button type="button" class="btn btn-primary me-3" wire:click="confirmTransfer">
                <span wire:loading.remove wire:target="confirmTransfer">{{ __('transfers.confirm_transfer') }}</span>
                <span wire:loading wire:target="confirmTransfer">
                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    {{ __('transfers.processing') }}...
                </span>
            </button>
            <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal" aria-label="Close">
                {{ __('actions.cancel') }}
            </button>
        </div>
    </form>
</div>
