<div class="card p-4 shadow rounded-2xl">
    <div wire:loading.delay>
        <div class="alert alert-info">جاري تحميل الإحصائيات...</div>
    </div>

    <div class="card">

        <div class="table-responsive text-nowrap">
            <table class="table table-boardered table-striped">

                <tbody class="table-border-bottom-0">
                    <tr>
                        <td>
                            <i class="ti   ti-user ti-lg text-primary me-3"></i> اسم الحساب
                        </td>
                        <td> <strong> {{ $totals['account_name'] }} </strong></td>

                        <td> <i class="ti   ti-wallet ti-lg text-primary me-3"></i> الرصيد السابق </td>
                        <td><strong>{{ $totals['opening_balance'] < 0 ? $totals['opening_balance'] * -1 . ' لنا' : $totals['opening_balance'] . ' علينا' }}</strong>
                        </td>

                    </tr>



                    <tr>
                        <td>
                            <i class="ti   ti-cash ti-lg text-primary me-3"></i> العملة
                        </td>
                        <td> <strong> {{ $totals['currency'] }} </strong></td>

                        <td> <i class="ti   ti-chart-line ti-lg text-primary me-3"></i> الرصيد الحالي </td>
                        <td><strong>{{ $totals['balance_type'] }}
                                {{ PriceFormat(round($totals['current_balance'])) }}</strong></td>

                    </tr>


                    <tr>
                        <td>
                            <i class="ti ti-calendar ti-lg text-primary me-3"></i> من تاريخ
                        </td>
                        <td> <strong> {{ $totals['fromDate'] }} </strong></td>

                        <td> <i class="ti ti-calendar ti-lg text-primary me-3"></i> الى تاريخ </td>
                        <td><strong> {{ $totals['toDate'] }} </strong></td>

                    </tr>


                    <tr>
                        <td>
                            <i class="ti ti-arrows-shuffle ti-lg text-primary me-3"></i> عدد الحركات
                        </td>
                        <td> <strong> {{ $totals['entry_count'] }} </strong></td>

                        <td> <i class="ti ti-building-bank ti-lg text-primary me-3"></i> رقم الصندوق </td>
                        <td><strong> {{ $totals['account_code'] }} </strong></td>

                    </tr>


                    <tr>
                        <td class="text-primary">
                            <i class="ti ti-arrow-up-right ti-lg text-primary me-3"></i> عدد الحركات الصادرة
                        </td>
                        <td class="text-primary"> <strong> {{ $totals['outTransfers'] }} </strong></td>

                        <td class="text-danger"> <i class="ti ti-arrow-down-left ti-lg text-danger me-3"></i> عدد
                            الحركات الواردة </td>
                        <td class="text-danger"><strong> {{ $totals['inTransfers'] }} </strong></td>

                    </tr>

                    <tr>
                        <td class="text-primary">
                            <i class="ti ti-arrow-up-circle ti-lg text-primary me-3"></i> اجمالي المدين لنا
                        </td>
                        <td class="text-primary"> <strong>{{ format_money($totals['total_debit']) }}</strong></td>

                        <td class="text-danger"> <i class="ti ti-arrow-down-circle ti-lg text-danger me-3"></i>
                            اجمالي الدائن علينا </td>
                        <td class="text-danger"><strong>{{ format_money($totals['total_credit']) }}</strong></td>

                    </tr>


                    <tr>
                        <td>
                            <i class="ti ti-pencil ti-lg text-primary me-3"></i> الرصيد كتابة
                        </td>
                        <td colspan="3" class="text-right"> <strong> {{ $totals['currency_words'] }}
                                {{ $totals['balance_type'] }}
                            </strong></td>



                    </tr>

                </tbody>
            </table>
        </div>
    </div>
</div>
