<div class="col-md-8">
    <div class="card">
        <h5 class="card-header">{{ __('shortcuts.add') }}</h5>
        <div class="card-body">
            <form wire:submit.prevent="addShortcut" enctype="multipart/form-data">

                {{-- Visible Label --}}
                <div class="mb-4">
                    <label for="shortcutName" class="form-label">{{ __('shortcuts.name') }}</label>
                    <input type="text" id="shortcutName" class="form-control" placeholder="Enter shortcut name"
                        wire:model.defer="name">
                    @error('name')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                {{-- URL Select --}}
                <div class="mb-4 select2_content">
                    <label for="shortcutUrl" class="form-label">{{ __('shortcuts.url') }}</label>
                    <x-Mulk.select2 id="shortcutUrl" class="form-select" wire:model.defer="url">
                        <option value="">-{{ __('general.select') }}</option>
                        @foreach ($menuOptions as $url => $label)
                            <option value="{{ $url }}">{{ $label }}</option>
                        @endforeach
                    </x-Mulk.select2>
                    @error('url')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                {{-- Icon Upload --}}
                <div class="mb-4">
                    <label for="shortcutIcon" class="form-label">{{ __('shortcuts.icon') }}</label>
                    <input type="file" id="shortcutIcon" class="form-control" wire:model="iconFile" accept="image/*">
                    @error('iconFile')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror

                    @if ($iconFile)
                        <div class="mt-2">
                            <img src="{{ $iconFile->temporaryUrl() }}" alt="Preview" class="img-thumbnail"
                                style="width: 60px; height: 60px;">
                        </div>
                    @endif
                </div>

                @if ($editId)
                    <button type="button" wire:click="updateShortcut"
                        class="btn btn-success">{{ __('actions.save') }}</button>
                    <button type="button" wire:click="$set('editId', null)"
                        class="btn btn-secondary">{{ __('actions.cancel') }}</button>
                @else
                    <button type="submit" class="btn btn-primary">{{ __('actions.save') }}</button>
                @endif
            </form>
        </div>
    </div>

    {{-- Shortcuts List --}}
    <div class="card mt-4">
        <h5 class="card-header">{{ __('shortcuts.list_all') }}</h5>
        <div class="card-body">
            @if ($shortcuts->isEmpty())
                <p class="text-muted">No shortcuts added yet.</p>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead>
                            <tr>
                                <th>{{ __('shortcuts.icon') }}</th>
                                <th>{{ __('shortcuts.name') }}</th>
                                <th>{{ __('shortcuts.url') }}</th>
                                <th class="text-center">{{ __('actions.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($shortcuts as $shortcut)
                                <tr>
                                    <td>
                                        <img src="{{ $shortcut->getFirstMediaUrl('icon', 'thumb') }}"
                                            alt="{{ $shortcut->name }}" class="rounded"
                                            style="width: 40px; height: 40px;">
                                    </td>
                                    <td>{{ $shortcut->name }}</td>
                                    <td>{{ $shortcut->url }}</td>
                                    <td class="text-center">
                                        <button wire:click="editShortcut({{ $shortcut->id }})"
                                            class="btn btn-sm btn-icon btn-text-primary" title="Edit">
                                            <i class="ti ti-pencil"></i>
                                        </button>
                                        <button wire:click="deleteShortcut({{ $shortcut->id }})"
                                            class="btn btn-sm btn-icon btn-text-danger" title="Delete"
                                            onclick="return confirm('Are you sure you want to delete this shortcut?')">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>

</div>
