<div>
    <div class="card p-4 shadow rounded-2xl">
        <h4 class="mb-4 text-xl font-semibold">Template Settings</h4>

        @if (session()->has('success'))
            <div class="alert alert-success mb-3">
                {{ session('success') }}
            </div>
        @endif

        <form wire:submit.prevent="save">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @foreach ($types as $type)
                    <div class="mb-3">
                        <label class="form-label capitalize">{{ ucfirst($type) }} Template</label>
                        <select wire:model="selectedTemplates.{{ $type }}" class="form-select">
                            <option value="">-- Select Template --</option>
                            @foreach ($templates[$type] ?? [] as $template)
                                <option value="{{ $template['id'] }}">{{ $template['name'] }}</option>
                            @endforeach
                        </select>
                    </div>
                @endforeach
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                    Save Changes
                </button>
            </div>
        </form>
    </div>
</div>
