<div class="p-6 max-w-7xl mx-auto">
    <!-- Include the account form component -->
    @livewire('ledger.ledger-account-form')

    <!-- Notifications -->
    <div id="notifications" class="mb-6"></div>

    <!-- Header Section -->
    <div class="bg-gradient-to-r from-primary/5 to-primary/10 rounded-xl p-6 mb-8 border border-primary/20">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div class="flex items-center space-x-4 rtl:space-x-reverse">
                <div class="p-3 bg-primary/10 rounded-xl">
                    <i class="ti ti-sitemap text-2xl text-primary"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">شجرة الحسابات</h1>
                    <p class="text-gray-600 mt-1">إدارة وتنظيم الحسابات المحاسبية</p>
                </div>
            </div>

            <div class="flex flex-wrap items-center gap-3">
                <!-- Search Box -->
                <div class="relative">
                    <input type="text" wire:model.live.debounce.300ms="search" placeholder="البحث في الحسابات..."
                        class="form-control pe-10" style="min-width: 250px;">
                    <i class="ti ti-search absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                </div>

                <!-- Add Root Account Button -->
                <button class="btn btn-primary" wire:click="addRootAccount">
                    <i class="ti ti-plus me-2"></i>
                    إضافة حساب رئيسي
                </button>

                <!-- Refresh Button -->
                <button class="btn btn-outline-secondary" wire:click="$refresh">
                    <i class="ti ti-refresh me-2"></i>
                    تحديث
                </button>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">إجمالي الحسابات</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $this->totalAccounts }}</p>
                </div>
                <div class="p-3 bg-blue-100 rounded-xl">
                    <i class="ti ti-folder text-xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">الحسابات الرئيسية</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $this->rootAccounts }}</p>
                </div>
                <div class="p-3 bg-green-100 rounded-xl">
                    <i class="ti ti-folder-plus text-xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">الحسابات الفرعية</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $this->childAccounts }}</p>
                </div>
                <div class="p-3 bg-purple-100 rounded-xl">
                    <i class="ti ti-folder-minus text-xl text-purple-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">المستوى الأقصى</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $this->maxDepth }}</p>
                </div>
                <div class="p-3 bg-orange-100 rounded-xl">
                    <i class="ti ti-layers text-xl text-orange-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Tree View -->
    @if ($this->filteredAccounts->isEmpty())
        <div class="bg-white rounded-xl p-12 text-center shadow-sm border border-gray-100">
            <div class="max-w-md mx-auto">
                <div class="p-4 bg-gray-100 rounded-full w-20 h-20 mx-auto mb-6 flex items-center justify-center">
                    <i class="ti ti-folder-off text-3xl text-gray-400"></i>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 mb-2">لا توجد حسابات</h3>
                <p class="text-gray-600 mb-6">ابدأ بإنشاء حساب رئيسي جديد لبناء شجرة الحسابات</p>
                <button class="btn btn-primary" wire:click="addRootAccount">
                    <i class="ti ti-plus me-2"></i>
                    إضافة حساب رئيسي
                </button>
            </div>
        </div>
    @else
        <!-- Chart of Accounts -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <!-- Header -->
            <div class="p-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <h3 class="text-lg font-semibold text-amber-600">دليل الحسابات</h3>
                    <button
                        class="w-8 h-8 bg-amber-500 hover:bg-amber-600 rounded-full flex items-center justify-center transition-all duration-200 shadow-sm hover:shadow-md hover:scale-110">
                        <i class="ti ti-plus text-white text-sm"></i>
                    </button>
                </div>

                <!-- Search Bar -->
                <div class="mt-3">
                    <div class="relative">
                        <input type="text" wire:model.live.debounce.300ms="search" placeholder="بحث"
                            class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                        <i class="ti ti-search absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                    </div>
                </div>
            </div>

            <!-- Tree Content -->
            <div class="p-4 max-h-96 overflow-y-auto">
                <div class="space-y-1">
                    @foreach ($this->filteredAccounts as $account)
                        @livewire(
                            'ledger.modern-account-tree-node',
                            [
                                'account' => $account,
                                'level' => 0,
                                'search' => $search ?? '',
                                'expandedNodes' => $expandedNodes,
                            ],
                            key($account->ledgerUuid)
                        )
                    @endforeach
                </div>
            </div>
        </div>
    @endif
</div>

@push('scripts')
    <script>
        // Debug: Log when page loads
        console.log('Tree component loaded');

        // Notification system
        Livewire.on('notify', (data) => {
            console.log('Notification received:', data);
            const notificationsDiv = document.getElementById('notifications');
            const notification = document.createElement('div');

            const alertClass = data.type === 'success' ? 'alert-success' : 'alert-danger';
            const icon = data.type === 'success' ? 'ti ti-check-circle' : 'ti ti-alert-circle';

            notification.className = `alert ${alertClass} alert-dismissible fade show`;
            notification.innerHTML = `
            <i class="${icon} me-2"></i>
            ${data.message}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        `;

            notificationsDiv.appendChild(notification);

            // Auto-remove after 5 seconds
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.remove();
                }
            }, 5000);
        });

        // Debug: Listen for all Livewire events
        Livewire.on('*', (eventName, ...args) => {
            console.log('Livewire event:', eventName, args);
        });
    </script>
@endpush
