<div>
    <!-- Modal -->
    <div id="ledgerAccountModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="ledgerAccountModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="ledgerAccountModalLabel">
                        {{ $mode === 'edit' ? 'تعديل الحساب' : 'إضافة حساب جديد' }}
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form wire:submit.prevent="save" onsubmit="console.log('Form submitted')">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="code" class="form-label">رمز الحساب *</label>
                                    <input type="text" class="form-control @error('code') is-invalid @enderror"
                                        id="code" wire:model="code" placeholder="مثال: 1000">
                                    @error('code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">اسم الحساب *</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                        id="name" wire:model="name" placeholder="مثال: الأصول">
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label class="form-label">نوع الحساب</label>
                                    <div class="d-flex gap-4 align-items-center">
                                        <!-- Credit/Debit Radio Buttons -->
                                        <div class="d-flex gap-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="accountType"
                                                    id="debit" wire:model="debit" value="1">
                                                <label class="form-check-label" for="debit">
                                                    حساب مدين
                                                </label>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="accountType"
                                                    id="credit" wire:model="credit" value="1">
                                                <label class="form-check-label" for="credit">
                                                    حساب دائن
                                                </label>
                                            </div>
                                        </div>

                                        <!-- Category Checkbox -->
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="category"
                                                wire:model="category">
                                            <label class="form-check-label" for="category">
                                                حساب تصنيف
                                            </label>
                                        </div>
                                    </div>
                                    @error('debit')
                                        <div class="text-danger small">{{ $message }}</div>
                                    @enderror
                                    @error('credit')
                                        <div class="text-danger small">{{ $message }}</div>
                                    @enderror
                                    @error('category')
                                        <div class="text-danger small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        @if ($parentUuid)
                            <div class="alert alert-info">
                                <i class="ti ti-info-circle me-2"></i>
                                سيتم إضافة هذا الحساب كحساب فرعي للحساب المحدد.
                            </div>
                        @endif

                        <!-- Debug Info -->
                        <div class="alert alert-warning">
                            <strong>Debug:</strong> Mode: {{ $mode }}, Code: {{ $code }}, Name:
                            {{ $name }},
                            Debit: {{ $debit ? 'Yes' : 'No' }}, Credit: {{ $credit ? 'Yes' : 'No' }},
                            Category: {{ $category ? 'Yes' : 'No' }}
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                        <button type="submit" class="btn btn-primary" onclick="console.log('Submit button clicked')">
                            <i class="ti ti-check me-1"></i>
                            {{ $mode === 'edit' ? 'تحديث' : 'إنشاء' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
