<div>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="card card-action mb-4">
                <div class="card-body pb-0">
                    <form class="card-body" wire:submit.prevent="search">
                        <div class="row g-3">
                            <!-- Sender Agent -->
                            <div class="col-md-6 select2_content">
                                <label class="form-label">{{ __('transfers.sender_agent') }}</label>
                                <x-Mulk.select2 wire:model="filters.sender_id" class="form-select" tabindex=1>
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($senders as $sender)
                                        <option value="{{ $sender->id }}">{{ $sender->code }} - {{ $sender->name }}
                                        </option>
                                    @endforeach
                                </x-Mulk.select2>
                            </div>

                            <!-- Receiver Agent -->
                            <div class="col-md-6 select2_content">
                                <label class="form-label">{{ __('transfers.receiver_agent') }}</label>
                                <x-Mulk.select2 wire:model="filters.receiver_id" class="form-select">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($receivers as $receiver)
                                        <option value="{{ $receiver->id }}">{{ $receiver->code }} -
                                            {{ $receiver->name }}</option>
                                    @endforeach
                                </x-Mulk.select2>
                            </div>

                            <!-- Recipient Name -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.recipient_name') }}</label>
                                <input type="text" class="form-control" wire:model="filters.recipient_name" />
                            </div>

                            <!-- Recipient Phone -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.recipient_phone') }}</label>
                                <input type="text" class="form-control phone-mask"
                                    wire:model="filters.recipient_phone" />
                            </div>

                            <!-- Sender Client Name -->
                            <div class="col-md-6">
                                <label class="form-label">اسم المرسل</label>
                                <input type="text" class="form-control" wire:model="filters.sender_client_name" />
                            </div>

                            <!-- Sender Client Phone -->
                            <div class="col-md-6">
                                <label class="form-label"> رقم المرسل</label>
                                <input type="text" class="form-control phone-mask"
                                    wire:model="filters.sender_client_phone" />
                            </div>

                            <!-- Sent Currency -->
                            <div class="col-md-6 select2_content">
                                <label class="form-label">{{ __('transfers.sent_currency') }}</label>
                                <x-Mulk.select2 wire:model="filters.currency" class="form-select">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}</option>
                                    @endforeach
                                </x-Mulk.select2>
                            </div>

                            <!-- Amount to Send with Operator -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.amount_to_send') }}</label>
                                <div class="input-group">
                                    <div class="dropdown">
                                        <button class="btn btn-outline-primary dropdown-toggle" type="button"
                                            id="amountOperatorDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                            {{ $amount_operator == '=' ? 'مساوي' : ($amount_operator == '>' ? 'اكبر من' : 'اقل من') }}
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="amountOperatorDropdown">
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('amount_operator', '>')"> اكبر من</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('amount_operator', '<')"> اقل من </a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('amount_operator', '=')"> مساوي</a></li>
                                        </ul>
                                    </div>
                                    <input type="number" class="form-control" placeholder="0.00"
                                        wire:model.lazy="filters.amount" />
                                </div>
                            </div>

                            <!-- Delivery Currency -->
                            <div class="col-md-6 select2_content">
                                <label class="form-label">{{ __('transfers.delivery_currency') }}</label>
                                <x-Mulk.select2 wire:model="filters.delivery_currency" class="form-select">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->code }}</option>
                                    @endforeach
                                </x-Mulk.select2>
                            </div>



                            <!-- Total to Receive with Operator -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.total_to_receive') }}</label>
                                <div class="input-group">
                                    <div class="dropdown">
                                        <button class="btn btn-outline-primary dropdown-toggle" type="button"
                                            id="deliveryAmountOperatorDropdown" data-bs-toggle="dropdown"
                                            aria-expanded="false">
                                            {{ $delivery_amount_operator == '=' ? 'مساوي' : ($delivery_amount_operator == '>' ? 'اكبر من' : 'اقل من') }}
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="deliveryAmountOperatorDropdown">
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('delivery_amount_operator', '>')"> اكبر من</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('delivery_amount_operator', '<')"> اقل من </a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('delivery_amount_operator', '=')"> مساوي</a></li>
                                        </ul>
                                    </div>
                                    <input type="number" class="form-control" placeholder="0.00"
                                        wire:model="filters.delivery_amount" />
                                </div>
                            </div>
 <!-- Date Range -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.from_date') }}</label>
                                <x-Mulk.date wire:model.defer="filters.from_date" class="form-control" />
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.to_date') }}</label>
                                <x-Mulk.date wire:model.defer="filters.to_date" class="form-control" />
                            </div>
                            <!-- Transfer Fee -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.transfer_fee') }}</label>
                                <div class="input-group">
                                    <div class="dropdown">
                                        <button class="btn btn-outline-primary dropdown-toggle" type="button"
                                            id="feeTypeDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                            {{ $send_fee_operator == '=' ? 'مساوي' : ($send_fee_operator == '>' ? 'اكبر من' : 'اقل من') }}
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="feeTypeDropdown">
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('send_fee_operator', '>')"> اكبر من</a></li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('send_fee_operator', '<')"> اقل من </a>
                                            </li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('send_fee_operator', '=')"> مساوي</a>
                                            </li>
                                        </ul>
                                    </div>
                                    <input type="number" class="form-control" wire:model.live="filters.send_fee"
                                        id="fee1" />
                                </div>
                            </div>

                            <!-- Receiver Fee -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('transfers.receiver_fee') }}</label>
                                <div class="input-group">
                                    <div class="dropdown">
                                        <button class="btn btn-outline-primary dropdown-toggle" type="button"
                                            id="feeTypeDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                            {{ $receiver_fee_operator == '=' ? 'مساوي' : ($receiver_fee_operator == '>' ? 'اكبر من' : 'اقل من') }}
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="feeTypeDropdown">
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('receiver_fee_operator', '>')"> اكبر من</a>
                                            </li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('receiver_fee_operator', '<')"> اقل من </a>
                                            </li>
                                            <li><a class="dropdown-item" href="javascript:void(0);"
                                                    wire:click="$set('receiver_fee_operator', '=')"> مساوي</a>
                                            </li>
                                        </ul>
                                    </div>
                                    <input type="number" class="form-control" wire:model.live="filters.receiver_fee"
                                        id="fee1" />
                                </div>
                            </div>

                            <!-- Type -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('general.type') }}</label>
                                <select class="form-select" wire:model="filters.type">
                                    <option value="all">الكل</option>
                                    <option value="transfer">حوالات</option>
                                    <option value="booking">قيود</option>
                                    <option value="approval">اعتمادات</option>
                                </select>
                            </div>

                            <!-- Status -->
                            <div class="col-md-6">
                                <label class="form-label">{{ __('general.status') }}</label>
                                <select class="form-select" wire:model="filters.status">
                                    <option value="all">الكل</option>
                                    <option value="completed">مستلمة</option>
                                    <option value="pending">غير مستلمة</option>
                                    <option value="deleted">محذوفة</option>
                                </select>
                            </div>

                            <!-- Buttons -->
                            <div class="d-grid col-6 mx-auto">
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="ti ti-search"></i> {{ __('general.search') }}
                                    </button>
                                    <button type="button" wire:click="resetFilters" class="btn btn-secondary">
                                        <i class="ti ti-rotate-2"></i> {{ __('general.reset') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
