<div>
    <div class="row g-4">

        <!-- Total Transfers -->
        <x-dashboard.card title="{{ __('dashboard.total_transfers') }}" icon="ti-transfer-in" color="primary"
            :count="$statistics['total']">
            <span class="badge bg-label-info">{{ $statistics['transfer'] }} {{ __('dashboard.transfers') }}</span>
            <span class="badge bg-label-success ms-1">{{ $statistics['approval'] }} {{ __('dashboard.approval') }}</span>
            <span class="badge bg-label-warning ms-1">{{ $statistics['booking'] }} {{ __('dashboard.booking') }}</span>
        </x-dashboard.card>

        <!-- Internal / External -->
        <x-dashboard.card title="{{ __('dashboard.direction') }}" icon="ti-arrows-left-right" color="danger"
            :count="$statistics['internal'] + $statistics['external']">
            <span class="badge bg-label-secondary"> {{ __('dashboard.internal') }}: {{ $statistics['internal'] }}</span>
            <span class="badge bg-label-danger ms-1">{{ __('dashboard.external') }}:
                {{ $statistics['external'] }}</span>
        </x-dashboard.card>


        <!-- Delivered / Undelivered -->
        <x-dashboard.card title="{{ __('dashboard.delivery') }}" icon="ti-package" color="warning" :count="$statistics['delivered'] + $statistics['undelivered']">
            <span class="badge bg-label-success">{{ __('dashboard.delivered') }} :
                {{ $statistics['delivered'] }}</span>
            <span class="badge bg-label-secondary ms-1">{{ __('dashboard.undelivered') }} :
                {{ $statistics['undelivered'] }}</span>
        </x-dashboard.card>
        <!-- Deleted -->
        <x-dashboard.card title="{{ __('dashboard.deleted_transfers') }}" icon="ti-trash" color="dark"
            :count="$statistics['cancelled']">
            <span class="badge bg-label-danger">{{ __('dashboard.transfers') }} :
                {{ $statistics['trashed_transfers'] }}</span>
            <span class="badge bg-label-danger ms-1">{{ __('dashboard.bookings') }} :
                {{ $statistics['trashed_bookings'] }}</span>
        </x-dashboard.card>

        @foreach ($currencyStatistics as $currencyCode => $currencyStats)
            <!-- {{ $currencyStats['currency_name'] }} Total -->
            <x-dashboard.card :title="$currencyStats['currency_name'] . ' ' . __('dashboard.total_sent')" icon="ti-currency-dollar" :color="$currencyStats['currency_color'] ?? 'primary'" :count="PriceFormat($currencyStats['total_amount'])">
                <span class="badge bg-label-info">{{ __('dashboard.transfer_count') }}:
                    {{ $currencyStats['total'] }}</span>
                <span class="badge bg-label-primary ms-1">{{ __('dashboard.send_fee') }}:
                    {{ PriceFormat($currencyStats['send_fee']) }}</span>

            </x-dashboard.card>

            <!-- {{ $currencyStats['currency_name'] }} Position -->
            @if ($currencyStats['currency_amount'] != 0)
                <x-dashboard.card :title="'   مركز قطع ' . $currencyStats['currency_name']" icon="ti-chart-line" :image="$currencyStats['currency_image']" :color="$currencyStats['currency_color'] ?? 'info'"
                    :count="PriceFormat($currencyStats['currency_amount'] * -1)">


                    <span class="badge bg-label-warning ms-1">التكلفة :
                        {{ round($currencyStats['exchange_cost'], 4) }}</span>

                </x-dashboard.card>
            @endif
        @endforeach








    </div>


</div>
