<div class="modal fade" id="ImportModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document" wire:ignore.self>
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <div class="w-100 d-flex justify-content-between align-items-center">
                    <h5 class="modal-title fs-4 fw-semibold text-primary">
                        <i class="ti ti-file-import me-2"></i>
                        {{ __('general.import') }}
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
            </div>

            <div class="modal-body pt-1">
                <div class="stepper mb-4">
                    <div class="stepper-step @if ($file) completed @endif">
                        <div class="stepper-circle">
                            @if ($file)
                                <i class="ti ti-check"></i>
                            @else
                                1
                            @endif
                        </div>
                        <div class="stepper-label">Upload File</div>
                    </div>
                    <div class="stepper-line @if ($columns && $headers) completed @endif"></div>
                    <div class="stepper-step @if ($columns && $headers) completed @endif">
                        <div class="stepper-circle">
                            @if ($columns && $headers)
                                <i class="ti ti-check"></i>
                            @else
                                2
                            @endif
                        </div>
                        <div class="stepper-label">Map Columns</div>
                    </div>
                    <div class="stepper-line @if ($batchId) completed @endif"></div>
                    <div class="stepper-step @if ($batchId) active @endif">
                        <div class="stepper-circle">
                            @if ($progress === 100)
                                <i class="ti ti-check"></i>
                            @else
                                3
                            @endif
                        </div>
                        <div class="stepper-label">Import Data</div>
                    </div>
                </div>

                <form wire:submit.prevent="parse" class="mb-4">
                    <div class="file-upload-card p-4 border rounded-3 bg-light">
                        <div class="d-flex flex-column align-items-center text-center">
                            <i class="ti ti-upload mb-3 fs-2 text-muted"></i>
                            <h6 class="mb-2">Upload Excel File</h6>
                            <p class="text-muted small mb-3">Supported formats: .xlsx, .xls, .csv</p>

                            <div class="position-relative w-100">
                                <input type="file" wire:model="file" id="file" class="d-none">
                                <label for="file" class="btn btn-primary px-4">
                                    <i class="ti ti-file-spreadsheet me-2"></i>
                                    Choose File
                                </label>
                                @if ($file)
                                    <span class="ms-3 text-truncate d-inline-block" style="max-width: 200px;">
                                        <i class="ti ti-file-text me-1"></i>
                                        {{ $file->getClientOriginalName() }}
                                    </span>
                                @endif
                            </div>
                            @error('file')
                                <div class="alert alert-danger mt-3 p-2 small">
                                    <i class="ti ti-alert-circle me-1"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </form>

                @if ($columns && $headers)
                    <form wire:submit.prevent="import" class="mt-4">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0">
                                    <i class="ti ti-columns-3 me-2"></i>
                                    Column Mapping
                                </h6>
                            </div>
                            <div class="card-body -mb-2">
                                <div class="row g-3">
                                    @foreach ($columns as $modelField)
                                        <div class="col-md-6">
                                            <label class="form-label fw-semibold small">
                                                <i class="ti ti-arrow-right me-1 text-muted"></i>
                                                {{ __('fields.' . $modelField) }}
                                            </label>
                                            <select wire:model="mappings.{{ $modelField }}"
                                                class="form-select  form-control form-select-sm">
                                                <option value="">-- Select Column --</option>
                                                @foreach ($headers as $header)
                                                    <option value="{{ $header }}"
                                                        @if (strtolower($header) === strtolower($modelField)) selected @endif>
                                                        {{ $header }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="ti ti-database-import me-2"></i>
                                Import Data
                            </button>
                        </div>
                    </form>
                @endif

                @if ($batchId)
                    <div class="card border-0 shadow-sm mt-4" wire:poll.2000ms="getProgress">
                        <div class="card-header bg-light">
                            <h6 class="mb-0">
                                <i class="ti ti-loader me-2"></i>
                                Import Progress
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-2 small">
                                <span>Processing data...</span>
                                <span>{{ $progress }}% complete</span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar"
                                    style="width: {{ $progress }}%" aria-valuenow="{{ $progress }}"
                                    aria-valuemin="0" aria-valuemax="100">
                                </div>
                            </div>

                            @if ($errorCount > 0)
                                <div class="alert alert-warning mt-3 p-2 small">
                                    <i class="ti ti-alert-triangle me-1"></i>
                                    {{ $errorCount }} rows failed to import.

                                </div>
                            @endif

                            @if ($progress === 100)
                                <div class="alert alert-success mt-3 p-2 small">
                                    <i class="ti ti-circle-check me-1"></i>
                                    Import completed successfully!
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <style>
        .stepper {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
        }

        .stepper-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            flex: 1;
        }

        .stepper-step.completed .stepper-circle {
            background-color: #4CAF50;
            color: white;
        }

        .stepper-step.active .stepper-circle {
            border-color: #3b82f6;
            color: #3b82f6;
            font-weight: bold;
        }

        .stepper-circle {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            border: 2px solid #ccc;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            background-color: white;
        }

        .stepper-label {
            font-size: 0.75rem;
            color: #666;
            text-align: center;
        }

        .stepper-line {
            flex: 1;
            height: 2px;
            background-color: #ccc;
            margin: 0 10px;
        }

        .stepper-line.completed {
            background-color: #4CAF50;
        }

        .file-upload-card {
            border: 2px dashed #dee2e6;
            transition: all 0.3s;
        }

        .file-upload-card:hover {
            border-color: #3b82f6;
            background-color: rgba(59, 130, 246, 0.05);
        }
    </style>
</div>
