<div>
    <div class="card">
        <div class="card-header">
            <h5 class="card-title">Features</h5>
        </div>

        <div class="card-body">
            <div class="row g-6 p-2">

                <div class="col-sm-6">
                    <label class="form-label d-block" for="plBedrooms">Feature
                        Name</label>
                    <div class="input-group">
                        <input type="text" class="form-control @error('feature_name') is-invalid @enderror"
                            wire:model="feature_name">
                        <button class="btn btn-outline-primary waves-effect" type="button" wire:click="AddFeature"
                            id="button-addon2"><i class="ti ti-plus"></i></button>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="col-sm-6 p-6">

                        <label class="switch">
                            <input type="checkbox" class="switch-input" wire:click="$toggle('select_all')" />
                            <span class="switch-toggle-slider">
                                <span class="switch-on"></span>
                                <span class="switch-off"></span>
                            </span>
                            <span class="switch-label">Select All</span>
                        </label>
                    </div>

                </div>
            </div>
            <div class="row g-6 p-2">
                @foreach ($features as $feature)
                    <div class="col-sm-3 ps-3 p-1 m-0 ">
                        <div class="form-check form-check-primary mt-4">
                            <input class="form-check-input" type="checkbox" wire:model="selected_features"
                                value="{{ $feature['id'] }}" id="customCheckPrimary"
                                @if (in_array($feature['id'], $selected_features)) checked @endif>
                            <label class="form-check-label" for="customCheckPrimary">{{ $feature['name'] }}</label>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row g-6 p-2">
                <div class="col-sm-12">
                    <button class="btn btn-outline-primary waves-effect" type="button" wire:click="SaveFeatures"
                        id="button-addon2"><i class="ti ti-check"></i> Save</button>
                </div>
            </div>
        </div>

    </div>

</div>
