<div>
    <div class="card">
        <div class="card-header">
            <h5 class="card-title">Facades</h5>
        </div>

        <div class="card-body">
            <div class="row g-6 p-2">

                <div class="col-sm-6">
                    <label class="form-label d-block">Facade
                        Name</label>
                    <div class="input-group">
                        <input type="text" class="form-control @error('facade_name') is-invalid @enderror"
                            wire:model="facade_name">
                        <button class="btn btn-outline-primary waves-effect" type="button" wire:click="AddFacade"
                            id="button-addon2"><i class="ti ti-plus"></i></button>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="col-sm-6 p-6">

                        <label class="switch">
                            <input type="checkbox" class="switch-input" wire:click="$toggle('select_all')" />
                            <span class="switch-toggle-slider">
                                <span class="switch-on"></span>
                                <span class="switch-off"></span>
                            </span>
                            <span class="switch-label">Select All</span>
                        </label>
                    </div>

                </div>

            </div>
            <div class="row g-6 p-2">
                @foreach ($facades as $facade)
                    <div class="col-sm-3 ps-3 p-1 m-0 ">
                        <div class="form-check form-check-primary mt-4">
                            <input class="form-check-input" type="checkbox" value="{{ $facade['id'] }}"
                                id="customCheckPrimary" wire:model="selected_facades"
                                @if (in_array($facade['id'], $selected_facades)) checked @endif>
                            <label class="form-check-label" for="customCheckPrimary">{{ $facade['name'] }}</label>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row g-6 p-2">
                <div class="col-sm-12">
                    <button class="btn btn-outline-primary waves-effect" type="button" wire:click="SaveFacades"
                        id="button-addon2"><i class="ti ti-check"></i> Save</button>
                </div>
            </div>
        </div>

    </div>


</div>
