<div>


    <div class="row">
        <div class="col-md-6 mb-6 select2_content">
            <x-Mulk.select2 wire:model.live="selected_contract">
                <option value="">Select Contract</option>
                @foreach ($contracts as $contract_select)
                    <option value="{{ $contract_select->id }}" data-color="{{ $contract_select->color ?? '#007bff' }}"
                        {{-- fallback to blue if no color --}}>{{ $contract_select->contract_name }}
                        {{ $contract_select->id }}</option>
                @endforeach
            </x-Mulk.select2>
        </div>
    </div>
    @if ($contract)
        <div class="row text-nowrap">
            <div class="col-md-6 mb-6">
                <div class="card h-100">
                    <div class="card-body">

                        <div class="card-info">
                            <h5 class="card-title mb-2">{{ __('contract.rent_amount') }}
                                ({{ $contract->rent->translated_type ?? '' }})</h5>
                            <div class="d-flex align-items-baseline gap-1">
                                <span
                                    class="badge bg-label-primary mb-2">{{ PriceFormat((float) $rent->rent_amount) }}</span>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-6">
                <div class="card">
                    <div class="card-body">

                        <div class="card-info">
                            <h5 class="card-title mb-2">{{ __('contract.tax_amount') }} ({{ $rent->kdv }} %)</h5>
                            <span class="badge bg-label-warning mb-2">{{ PriceFormat($rent->getTotalTaxAmount()) }}
                            </span>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-6">
                <div class="card">
                    <div class="card-body">

                        <div class="card-info">
                            <h5 class="card-title mb-2">{{ __('contract.total_dept_amount') }}</h5>
                            <div class="d-flex align-items-baseline gap-1">
                                <h5 class="text-danger mb-0">{{ PriceFormat($contract->TotalUnpaidInvoicesAmount()) }}
                                </h5>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-6">
                <div class="card">
                    <div class="card-body">

                        <div class="card-info">
                            <h5 class="card-title mb-2">{{ __('contract.total_collected_amount') }}</h5>
                            <div class="d-flex align-items-baseline gap-1">
                                <h5 class="text-info mb-0">{{ PriceFormat($contract->TotalPaidInvoicesAmount()) }}</h5>

                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>







        <div class="card card-action mb-6">
            <div class="card-header">
                <h5 class="card-action-title mb-0">Sözleşme Bilgileri</h5>

                <div class="card-action-element">
                    <a href="javascript:void(0);" class="btn btn-primary me-4 waves-effect waves-light"
                        style="color: #fff;" @click="$dispatch('EditContract')"><i
                            class="tf-icons ti ti-plus scaleX-n1-rtl ti-sm"></i> {{ __('actions.add') }}</a>
                </div>
                <div class="card-action-element">
                    <div class="dropdown">
                        <a class="btn btn-link p-3" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="tf-icons ti ti-dots-vertical"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" style="min-width: 200px;">
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2" href="javascript:void(0);"
                                    @click="$dispatch('EditContract',  { contract_id: $wire.selected_contract })">
                                    <i class="tf-icons ti ti-edit ti-sm"></i>
                                    <span class="text-nowrap">{{ __('actions.edit') }}</span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2"
                                    href="/Contracts/Print/{{ $contract->id }}" target="_blank">
                                    <i class="tf-icons ti ti-printer ti-sm"></i>
                                    <span class="text-nowrap">{{ __('actions.print') }}</span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2" href="#"
                                    data-bs-toggle="modal" data-bs-target="#ContractConditionsModal">
                                    <i class="tf-icons ti ti-file-text ti-sm"></i>
                                    <span class="text-nowrap">{{ __('contract.terms') }}</span>
                                </a>
                            </li>
                            <li>
                                <hr class="dropdown-divider">
                            </li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2" href="javascript:void(0);"
                                    @click="$dispatch('showCollectionForm',  { contract_id: $wire.selected_contract, action: 'rent_tahsilati' })">
                                    <i class="tf-icons ti ti-cash ti-sm"></i>
                                    <span class="text-nowrap">Tahsilat</span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2" href="javascript:void(0);"
                                    @click="$dispatch('showCollectionForm',  { contract_id: $wire.selected_contract, action: 'deposit_tahsilati' })">
                                    <i class="tf-icons ti ti-coin ti-sm"></i>
                                    <span class="text-nowrap">Deposit Tahsilat</span>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center gap-2" href="javascript:void(0);"
                                    @click="$dispatch('showCollectionForm',  { contract_id: $wire.selected_contract, action: 'deposit_odeme' })">
                                    <i class="tf-icons ti ti-currency-lira ti-sm"></i>
                                    <span class="text-nowrap">Deposit Ödeme</span>
                                </a>
                            </li>
                        </ul>
                    </div>


                </div>
            </div>
            <div class="card-body">
                <div class="row g-6">

                    <div class="table-responsive">
                        <table class="table gs-0 gy-2 gs-4">
                            <tbody>


                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>{{ __('general.status') }}</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">
                                        <span
                                            class="@if ($contract->status == 'Active') text-success @else text-danger @endif ">{{ $contract->status }}
                                        </span><span><a href="javascript:void(0);" class="text-primary"
                                                wire:click="ChangeContractStatus"><i
                                                    class="ti ti-edit scaleX-n1-rtl ti-sm"></i></a></span>
                                    </td>

                                </tr>
                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>{{ __('general.portfolio') }}</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">

                                        <span>{{ $contract->property->portfolio->name }} </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>{{ __('general.property') }}</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">

                                        <span>{{ $contract->property->name }} </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>{{ __('general.amount') }}</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">

                                        <span>{{ PriceFormat($rent->rent_amount) }} </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>{{ __('general.type') }}</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">

                                        <span>{{ $contract->translated_type }} </span>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>Next Payment Date</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">

                                        <span>{{ $contract->rent->getNextDueDate() }} </span>
                                    </td>
                                </tr>







                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>Toplam Kiralanan Net ㎡</span>
                                    </td>
                                    <td class="text-start  fs-6 pb-3">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 pt-3">
                                        <span>{{ areaFormat($property->net_sqm) }} </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>Toplam Kiralanan Brüt ㎡</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0">
                                        <span>{{ areaFormat($property->gross_sqm) }}</span>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>Aidat Tutarı</span>
                                        <br>
                                        <span>KDV Oranı</span>
                                    </td>
                                    <td class="p-0 px-2 pt-3">
                                        :
                                        <br>
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 pt-3">
                                        <span>{{ PriceFormat($contract->fee->amount ?? 0) }}</span>
                                        <br>
                                        <span>% {{ $contract->fee->tax ?? 0 }}</span>
                                    </td>

                                </tr>

                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>Sözleşme Başlangıç</span>
                                        <br>
                                        <span>Sözleşme Bitiş</span>
                                    </td>
                                    <td class="p-0 px-2 pt-3">
                                        :
                                        <br>
                                        :
                                    </td>
                                    <td class="fw-bolder text-end fs-6 tnum  p-0 pt-3">
                                        <span>{{ $contract->contract_start }}</span>
                                        <br>
                                        <span>{{ $contract->contract_end }}</span>
                                    </td>
                                    <td class="text-center align-middle">
                                        <span
                                            style="display: inline-flex;flex-direction: inherit;justify-content: center;font-weight: 700;padding: 6px;color: #0C805B;border-radius: 15px;flex: none;order: 1;flex-grow: 0;font-size: 11px;text-align: center;border: 1px solid #0C805B;line-height: 20px;">

                                            353 GÜN </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>Kira Başlangıç</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="fw-bolder text-end fs-6 tnum p-0">
                                        <span>{{ $contract->rent_start }}</span>
                                    </td>
                                    <td class="text-center align-middle">
                                        <span
                                            style="display: inline-flex;flex-direction: inherit;justify-content: center;font-weight: 700;padding: 6px;color:#0C805B;border-radius: 15px;flex: none;order: 1;flex-grow: 0;font-size: 11px;text-align: center;border: 1px solid #0C805B;line-height: 20px;">
                                            {{ $contract->remain_days }} Days </span>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="text-start  fs-6 pb-3">
                                        <span>{{ __('contract.rented_dayes') }}</span>
                                    </td>
                                    <td class="p-0 px-2">
                                        :
                                    </td>
                                    <td class="text-end tnum fw-bolder fs-6 p-0 text-dark">

                                        {{ $contract->rented_days }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    @endif
    @include('Modals.change_contract_status')
    @include('Modals.contract_conditions')
    <livewire:components.collection-form :contract="$contract" />

</div>
