<div>
    <div>
        <video id="video" width="320" height="240" autoplay></video>
        <canvas id="canvas" width="320" height="240" style="display:none;"></canvas>

        <div class="mt-2">
            <button type="button" onclick="capturePhoto()">Capture Photo</button>
            <button type="button" wire:click="savePhoto" {{ $photo ? '' : 'disabled' }}>Save Photo</button>
        </div>

        @if ($photo)
            <div class="mt-3">
                <p>Preview:</p>
                <img src="{{ $photo }}" alt="Captured Photo" width="320" height="240" />
            </div>
        @endif

        <script>
            let video = document.getElementById('video');
            let canvas = document.getElementById('canvas');
            let context = canvas.getContext('2d');

            // Request access to webcam
            navigator.mediaDevices.getUserMedia({
                    video: true
                })
                .then(function(stream) {
                    video.srcObject = stream;
                    video.play();
                })
                .catch(function(err) {
                    alert("Error accessing the camera: " + err);
                });

            function capturePhoto() {
                context.drawImage(video, 0, 0, canvas.width, canvas.height);
                let dataUrl = canvas.toDataURL('image/png');

                // Set the photo property in Livewire
                @this.set('photo', dataUrl);
            }
        </script>
    </div>

</div>
