<div>
    <!-- Edit User Modal -->
    <div class="modal fade" id="AddNewAgentModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-simple " role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="mb-2">
                            {{ $title }}
                        </h4>

                    </div>
                    <form class="row g-2">
                        <div class="col-12 col-md-6 select2_content">
                            <label class="form-label">{{ __('agents.type') }} <span class="text-danger">*</span></label>
                            <select class="form-control" wire:model.live="agent.type" class="select2 form-select">

                                @foreach ($types as $type)
                                    <option value="{{ $type }}">{{ __('agents.' . $type) }}</option>
                                @endforeach
                            </select>
                            @error('agent.type')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        @if ($agent['type'] == 'cashier')
                            <div class="col-12 col-md-6 select2_content">
                                <label class="form-label">{{ __('agents.parent') }} <span
                                        class="text-danger">*</span></label>
                                <x-Mulk.select2 wire:model.live="agent.parent_id" class="select2 form-select">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($agents as $agent)
                                        <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                    @endforeach
                                </x-Mulk.select2>
                                @error('agent.parent_id')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                        @endif
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('agents.code') }} <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model.lazy="agent.code" class="form-control" />
                            @error('agent.code')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserFirstName">{{ __('agents.name') }} <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model.lazy="agent.name" class="form-control" />
                            @error('agent.name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        @if ($agent['type'] == 'agent' || $agent['type'] == 'cashier')
                            <div class="col-12 col-md-6">
                                <label class="form-label" for="modalEditUserFirstName">{{ __('agents.username') }}
                                    <span class="text-danger">*</span></label>
                                <input type="text" wire:model.lazy="agent.username" class="form-control"
                                    autocomplete="new-username" />
                                @error('agent.username')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-12 col-md-6">
                                <label class="form-label" for="modalEditUserFirstName">{{ __('agents.password') }}
                                    <span class="text-danger">*</span></label>
                                <input type="password" wire:model.lazy="agent.password" class="form-control"
                                    autocomplete="new-password" />
                                @error('agent.password')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        @endif

                        <div class="col-12 col-md-6 select2_content">
                            <label class="form-label">{{ __('address.country') }} <span
                                    class="text-danger">*</span></label>
                            <x-Mulk.select2 wire:model="address.country" class="select2 form-select">
                                <option value="">Select</option>
                                @foreach ($countries as $key => $value)
                                    <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </x-Mulk.select2>
                            @error('address.country')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('address.city') }} <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model.lazy="address.city" class="form-control" />

                            @error('address.city')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label"> المنطقة </label>
                            <input type="text" class="form-control" wire:model.lazy="address.state" />
                        </div>
                        <div class="col-md-6">
                            <label class="form-label"> الحي </label>
                            <input type="text" class="form-control" wire:model.lazy="address.neighborhood" />
                        </div>
                        <div class="col-md-6">
                            <label class="form-label"> الشارع </label>
                            <input type="text" class="form-control" wire:model.lazy="address.district" />
                        </div>
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('address.address') }}
                                @if ($agent['type'] == 'agent')
                                    <span class="text-danger">*</span>
                                @endif
                            </label>
                            <input type="text" wire:model.lazy="address.full_address" class="form-control" />
                        </div>
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('address.email') }} </label>
                            <input type="text" wire:model.lazy="agent.email" class="form-control"
                                placeholder="example@domain.com" value="example@domain.com" />
                            @error('agent.email')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>


                        <div class="col-12 col-md-6">
                            <label class="form-label" for="modalEditUserPhone">{{ __('agents.phone') }} <span
                                    class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text">{{ $selectedCountryName }}
                                    ({{ $phone_code }})</span>
                                <input type="text" wire:model.lazy="agent.phone"
                                    class="form-control phone-number-mask" placeholder="202 555 0111"
                                    value="202 555 0111" />

                            </div>
                            @error('agent.phone')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>


                        <div class="col-12">
                            <div class="form-check form-switch">
                                <input type="checkbox" class="form-check-input" wire:model="agent.is_active"
                                    @if ($agent['is_active'] == 1) checked @endif />
                                <label for="editBillingAddress"
                                    class="switch-label">{{ __('agents.status') }}</label>
                            </div>
                        </div>
                        <div class="col-12 text-center">
                            <button type="button" class="btn btn-primary me-3 position-relative"
                                wire:click="addAgent" wire:loading.attr="disabled" wire:target="addAgent">

                                <span wire:loading.remove wire:target="addAgent">
                                    {{ __('actions.save') }}
                                </span>

                                <span wire:loading wire:target="addAgent">
                                    <span class="spinner-border spinner-border-sm" role="status"
                                        aria-hidden="true"></span>
                                    {{ __('general.loading') }}
                                </span>
                            </button>
                            <button type="button" class="btn btn-info me-3 position-relative"
                                wire:click="CopyCredentials" wire:loading.attr="disabled"
                                wire:target="CopyCredentials">
                                <i class="tf-icons ti ti-copy"></i>
                                {{ __('actions.copy_credentials') }}
                            </button>
                            <button type="reset" class="btn btn-label-secondary" data-bs-dismiss="modal"
                                aria-label="Close">{{ __('actions.cancel') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


</div>
