<div>
    <div class="card">
        <div class="card-header">
            <h5 class="card-title">Filter</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">


                <div class="col-md-6 select2_content">
                    <label class="form-label"> العميل </label>

                    <x-Mulk.select2 class="form-control" wire:model.live="accountId">
                        <option value="">{{ __('general.select') }}</option>
                        @foreach ($accounts as $account)
                            <option value="{{ $account->code }}">
                                {{ optional($account->names->where('language', 'ar')->first())->name }}-{{ $account->code }}
                            </option>
                        @endforeach
                    </x-Mulk.select2>
                </div>

                <div class="col-md-6">
                    <label class="form-label"> تضمين الحركات غير المستلمة </label>
                    <br /> <input class="form-check-input" type="checkbox" />

                </div>


                <div class="col-md-6 select2_content">
                    <label class="form-label">{{ __('general.currency') }}</label>

                    <x-Mulk.select2 class="form-control" wire:model.live="currency">
                        <option value="">{{ __('general.select') }}</option>
                        @foreach ($currencies as $currency)
                            <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                        @endforeach
                    </x-Mulk.select2>
                </div>

                <div class="col-md-6">
                    <label class="form-label"> الوقت </label>

                    <select class="select2 form-select" wire:model="dateFilter" wire:change="onDateFilterChange">
                        <option value="custom">تحديد التاريخ</option>
                        <option value="today">اليوم فقط</option>
                        <option value="this_month">هذا الشهر فقط</option>
                        <option value="this_year">هذا العام فقط</option>
                        <option value="all">الكل</option>
                    </select>
                </div>
                @if ($dateFilter === 'custom')
                    <div class="col-md-6">
                        <label class="form-label">{{ __('general.from_date') }}</label>
                        <x-Mulk.date class="form-control" wire:model="fromDate" />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">{{ __('general.to_date') }}</label>
                        <x-Mulk.date class="form-control" wire:model="toDate" />
                    </div>
                @endif

                <div class="col-md-6">
                    <button class="btn btn-primary form-control" wire:click="applyFilter">كشف حساب</button>
                </div>
                <div class="col-md-6">
                    <button class="btn btn-info form-control" type="button" id="btnExportPdf"
                        onclick="exportStatementPdf()">
                        <i class="fa fa-file-pdf-o me-2"></i>طباعة PDF
                    </button>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    function exportStatementPdf() {
        // Show loading state
        const btn = document.getElementById('btnExportPdf');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fa fa-spinner fa-spin me-2"></i>جاري التصدير...';
        btn.disabled = true;

        try {
            // Collect current filters
            const filters = {
                account: document.querySelector('[wire\\:model\\.live="accountId"]')?.value || '',
                currency: document.querySelector('[wire\\:model\\.live="currency"]')?.value || '',
                dateFilter: document.querySelector('[wire\\:model="dateFilter"]')?.value || 'custom',
                fromDate: document.querySelector('[wire\\:model="fromDate"]')?.value || '',
                toDate: document.querySelector('[wire\\:model="toDate"]')?.value || '',
                includeUnreceived: document.querySelector('input[type="checkbox"]')?.checked || false
            };

            // Validate required fields
            if (!filters.account || !filters.currency) {
                alert('يرجى تحديد الحساب والعملة أولاً');
                btn.innerHTML = originalText;
                btn.disabled = false;
                return;
            }

            // Build query string
            const queryString = new URLSearchParams(filters).toString();
            const exportUrl = '{{ route('agent.statements.export-pdf') }}?' + queryString;

            console.log('Exporting PDF with URL:', exportUrl);
            console.log('Filters:', filters);
            console.log('CSRF Token:', document.querySelector('meta[name="csrf-token"]')?.getAttribute('content'));
            console.log('Current URL:', window.location.href);

            // Use fetch to handle the response and errors
            fetch(exportUrl, {
                    method: 'GET',
                    credentials: 'same-origin', // Include cookies and session data
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/pdf',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute(
                            'content') || ''
                    }
                })
                .then(response => {
                    console.log('Response status:', response.status);
                    console.log('Response headers:', response.headers);

                    if (!response.ok) {
                        if (response.status === 302) {
                            throw new Error('تم إعادة التوجيه - يرجى التأكد من تسجيل الدخول');
                        }
                        return response.json().then(errorData => {
                            throw new Error(errorData.error || 'فشل في تصدير PDF');
                        });
                    }
                    return response.blob();
                })
                .then(blob => {
                    // Create download link
                    const url = window.URL.createObjectURL(blob);
                    const a = document.createElement('a');
                    a.style.display = 'none';
                    a.href = url;

                    // Generate safe filename
                    const safeFilename = `statement_${filters.account}_${filters.currency}.pdf`
                        .replace(/[^a-zA-Z0-9_.-]/g, '_');

                    a.download = safeFilename;
                    document.body.appendChild(a);
                    a.click();
                    window.URL.revokeObjectURL(url);
                    document.body.removeChild(a);

                    console.log('PDF downloaded successfully');
                })
                .catch(error => {
                    console.error('PDF export error:', error);
                    alert('خطأ في تصدير PDF: ' + error.message);
                })
                .finally(() => {
                    // Restore button state
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                });

        } catch (error) {
            console.error('Error in export function:', error);
            alert('حدث خطأ أثناء تصدير PDF');
            btn.innerHTML = originalText;
            btn.disabled = false;
        }
    }
</script>
