<div>
    <div class="ticker-container">
        <div type="button" class="btn btn-label-primary">شركة الأخطبوط الأزرق</div>
        <div class="tickernews">

            <div class="news">

                @foreach ($news as $new)
                    <span>{{ $new->content }}</span>
                @endforeach

            </div>
        </div>
    </div>
    <div class= " flex-grow-1 container-p-y">
        <div class="row">


            @foreach ($balances as $balance)
                <div class="col-xl-3 col-md-4 col-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <span class="dropdown-shortcuts-icon rounded-circle mb-2">
                                <img src="{{ getCurrencyAvatar($balance['currency']) }}" alt="User"
                                    width="50" />
                            </span>
                            <h3 class="card-title mb-1 pt-2 text-{{ $balance['balance'] < 0 ? 'danger' : 'primary' }}">
                                {{ PriceFormat(round($balance['abs_balance'])) }}</h3>


                            <div class="pt-1">
                                <span class=" badge bg-label-{{ $balance['balance'] < 0 ? 'danger' : 'primary' }}">
                                    {{ \App\Models\Currency::getCurrencyName($balance['currency']) }}
                                    {{ $balance['label'] ?? ($balance['balance'] < 0 ? 'عليكم' : ' لكم') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach

            @if (Settings::get('agent.show_based_balance', 1))
                <div class="col-xl-3 col-md-4 col-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <span class="dropdown-shortcuts-icon rounded-circle mb-2">
                                <img src="{{ asset('assets/img/avatars/blc.png') }}" alt="User" width="50" />
                            </span>
                            <h3 class="card-title mb-1 pt-2 text-{{ $based_balance < 0 ? 'danger' : 'primary' }}">
                                {{ PriceFormat(abs(round($based_balance, 0))) }}</h3>


                            <div class="pt-1">
                                <span class=" badge bg-label-{{ $based_balance < 0 ? 'danger' : 'primary' }}">
                                    رصيد مقوم
                                    {{ $based_balance < 0 ? 'عليكم' : ' لكم' }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            @endif



            <div class="col-xl-6 mb-4 col-12">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="row gy-3">

                            <!-- بانتظار التسليم -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.InTransfers') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-primary me-3 p-2">
                                            <i class="ti ti-chart-pie-2 ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['received_transfers'] }}</h5>
                                            <small>بانتظار التسليم</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- بانتظار القبض -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.CollectTransfer') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-danger me-3 p-2">
                                            <i class="ti ti-chart-pie-2 ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['not_collected_transfers'] }}</h5>
                                            <small>بانتظار القبض</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- بانتظار الدفع -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.PayTransfers') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-info me-3 p-2">
                                            <i class="ti ti-chart-pie-2 ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['not_paid_transfers'] }}</h5>
                                            <small>بانتظار الدفع</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- حوالات صادرة -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.OutTransfers') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-info me-3 p-2">
                                            <i class="ti ti-arrow-up ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['sent_transfers'] }}</h5>
                                            <small>حوالات صادرة</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- حوالات مستلمة -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.DeliveredTransfers') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-success me-3 p-2">
                                            <i class="ti ti-check ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['delivered_transfers'] }}</h5>
                                            <small>حوالات مستلمة</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- حوالات صرف -->
                            <div class="col-md-3 col-6">
                                <a href=" #" class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-primary me-3 p-2">
                                            <i class="ti ti-refresh ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['exchange_transfer'] }}</h5>
                                            <small>حوالات صرف</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- اعتمادات صادرة -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.AgentApproval') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-danger me-3 p-2">
                                            <i class="ti ti-arrow-up ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['sent_approved_transfer'] }}</h5>
                                            <small>اعتمادات صادرة</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            <!-- اعتمادات واردة -->
                            <div class="col-md-3 col-6">
                                <a href="{{ route('agent.transfers.InAgentApproval') }}"
                                    class="text-decoration-none text-dark">
                                    <div class="d-flex align-items-center">
                                        <div class="badge rounded-pill bg-label-success me-3 p-2">
                                            <i class="ti ti-arrow-down ti-sm"></i>
                                        </div>
                                        <div class="card-info">
                                            <h5 class="mb-0">{{ $statistics['received_approved_transfer'] }}</h5>
                                            <small>اعتمادات واردة</small>
                                        </div>
                                    </div>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
</div>
