 <div class="row">

     <div class="col-xl-12 col-lg-12 col-md-12">
         <!-- Activity Timeline -->
         <div class="card card-action mb-4">

             <div class="card-body pb-0">
                 <div class="card-body">
                     @if ($type == 'account_statement')
                         @livewire('agent-panel.statement.filter', ['account' => $agent_id, 'accounts' => $accounts])
                     @else
                         <div class="row g-3 align-items-end">

                             <div class="col-md-6 select2_content">
                                 <label class="form-label">{{ __('client.client') }}</label>
                                 <x-Mulk.select2 class="  form-control" wire:model.live="agent_id">
                                     <option value="">{{ __('general.select') }}</option>
                                     @foreach ($agents as $agent)
                                         <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                     @endforeach
                                 </x-Mulk.select2>
                             </div>



                         </div>
                     @endif
                     <br />
                     <div id="written_balance_reconciliation_content" style="visibility: hidden; position: absolute;">
                         {!! $written_balance_reconciliation_content !!}
                     </div>

                     <div class="row mb-5" id="mutabaka">

                         <div class="col-md-12">
                             <div class="card mb-2"
                                 style="background:url({{ asset($background_image) }}); background-size: 500px;    ">
                                 <div class="row  ">

                                     <div class="col-md-auto">
                                         <button class="btn btn-primary mt-3 clipboard" type="button" id="copyBtn"
                                             class="clipboard"
                                             data-clipboard-target="#written_balance_reconciliation_content"
                                             aria-label="نسخ المحتوى"
                                             data-clipboard-text="{{ strip_tags($written_balance_reconciliation_content) }}">
                                             <i class="fa fa-copy me-1"></i>
                                         </button>
                                     </div>


                                     <div class="col-md-auto">
                                         <button class="btn btn-primary mt-3  " type="button" id="screenshotBtn">
                                             <i class="fa fa-camera me-1"></i>
                                         </button>
                                     </div>


                                 </div>
                                 <div class="row g-0">
                                     <div class="col-md-2  "
                                         style="padding: 20px;    20px;display: flex; justify-content: center; align-items: center;  ">
                                         <img class="card-img card-img-left img-fluid rounded mb-3 pt-1 mt-4"
                                             style="max-width: 40vw;" src="{{ asset($logo) }}" />
                                     </div>
                                     <div class="col-md-10">
                                         <div class="card-body text-center">
                                             {!! $balance_reconciliation_content !!}




                                         </div>
                                     </div>
                                 </div>
                             </div>
                         </div>
                         <div class="row">
                             @foreach ($balances as $balance)
                                 <div class="col-md-4 ">
                                     <div class="card mb-1">
                                         <div class="row g-0  ">
                                             <div class="col-md-4       "
                                                 style="padding: 20px;display: flex; justify-content: center; align-items: center; ">
                                                 <img class="card-img card-img-left rounded-circle border    "
                                                     src="{{ getCurrencyAvatar($balance['currency']) }}"
                                                     style="max-width: 20vw;" />
                                             </div>
                                             <div class="col-md-8 ">
                                                 <div class="card-body">

                                                     <h4
                                                         class="card-title  fw-bold text-center text-{{ $balance['balance'] < 0 ? 'primary' : 'danger' }}">
                                                         {{ \App\Models\Currency::getCurrencyName($balance['currency']) }}
                                                     </h4>
                                                     <h3
                                                         class="card-title  fw-bold text-center text-{{ $balance['balance'] < 0 ? 'primary' : 'danger' }}">
                                                         {{ PriceFormat($balance['abs_balance']) }} </h3>
                                                     <h4
                                                         class="card-title fw-bold text-center text-{{ $balance['balance'] < 0 ? 'primary' : 'danger' }}">
                                                         {{ $balance['label'] ?? ($balance['balance'] < 0 ? 'مدين لنا' : 'دائن علينا') }}
                                                     </h4>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             @endforeach
                         </div>






                     </div>

                 </div>
             </div>

         </div>
     </div>

 </div>
