<div>
    <div class="modal fade" id="FormConfigModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document" wire:ignore.self>
            <div class="modal-content border-0 shadow-lg">
                <!-- Modern Header with Gradient -->
                <div class="modal-header border-0   position-relative overflow-hidden">

                    <div class="position-relative z-1 w-100">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="bg-white bg-opacity-20 rounded-circle p-3 me-3">
                                    <i class="bx bx-cog bx-lg text-white"></i>
                                </div>
                                <div>
                                    <h4 class="mb-1   fw-bold">Form Configuration</h4>
                                    <p class="mb-0 text-white-50">{{ $formName }}</p>
                                </div>
                            </div>
                            <button type="button" class="btn-close " data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <div class="modal-body p-4">


                    <!-- Enhanced Table -->
                    <div class="card border-0 shadow-sm">

                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="bg-light">
                                        <tr>
                                            <th class="border-0 py-3 px-4 fw-semibold text-dark">
                                                <i class="bx bx-field me-2 text-primary"></i>Field
                                            </th>
                                            <th class="border-0 py-3 px-4 fw-semibold text-dark">
                                                <i class="bx bx-label me-2 text-primary"></i>Label
                                            </th>
                                            <th class="border-0 py-3 px-4 fw-semibold text-dark text-center">
                                                <i class="bx bx-show me-2 text-primary"></i>Visible
                                            </th>
                                            <th class="border-0 py-3 px-4 fw-semibold text-dark text-center">
                                                <i class="bx bx-required me-2 text-primary"></i>Required
                                            </th>
                                            <th class="border-0 py-3 px-4 fw-semibold text-dark text-center">
                                                <i class="bx bx-tab me-2 text-primary"></i>Tab Index
                                            </th>
                                            <th class="border-0 py-3 px-4 fw-semibold text-dark text-center">
                                                <i class="bx bx-lock me-2 text-primary"></i>Locked
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($fields as $index => $field)
                                            <tr class="border-bottom">
                                                <td class="py-3 px-4">
                                                    <div class="d-flex align-items-center">
                                                        <div class="bg-light-primary rounded-circle p-2 me-3">
                                                            <i class="bx bx-field text-primary"></i>
                                                        </div>
                                                        <div>
                                                            <span
                                                                class="fw-semibold text-dark">{{ $field['field'] }}</span>
                                                            @if ($field['always_required'])
                                                                <span
                                                                    class="badge bg-warning bg-opacity-10 text-warning ms-2">
                                                                    <i class="bx bx-lock me-1"></i>Locked
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="py-3 px-4">
                                                    <div class="form-floating">
                                                        <input type="text"
                                                            wire:model.defer="fields.{{ $index }}.label"
                                                            class="form-control border-0 bg-light"
                                                            placeholder="Custom label" id="label-{{ $index }}" />
                                                        <label for="label-{{ $index }}" class="text-muted">Custom
                                                            label</label>
                                                    </div>
                                                </td>
                                                <td class="py-3 px-4 text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input type="checkbox"
                                                            class="form-check-input form-check-input-lg"
                                                            wire:model="fields.{{ $index }}.visible"
                                                            @if ($field['always_required']) disabled @endif
                                                            wire:change="onVisibleChange({{ $index }})"
                                                            id="visible-{{ $index }}">
                                                        <label class="form-check-label ms-2"
                                                            for="visible-{{ $index }}"></label>
                                                    </div>
                                                </td>
                                                <td class="py-3 px-4 text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input type="checkbox"
                                                            class="form-check-input form-check-input-lg"
                                                            wire:model="fields.{{ $index }}.required"
                                                            @if ($field['always_required']) disabled @endif
                                                            id="required-{{ $index }}">
                                                        <label class="form-check-label ms-2"
                                                            for="required-{{ $index }}"></label>
                                                    </div>
                                                </td>
                                                <td class="py-3 px-4 text-center">
                                                    <div x-data="{
                                                        original: '{{ $fields[$index]['tab_index'] ?? '' }}',
                                                        current: '{{ $fields[$index]['tab_index'] ?? '' }}',
                                                        cleared: false
                                                    }" x-init="$watch('current', value => $wire.set('fields.{{ $index }}.tab_index', value))">
                                                        <div class="form-floating">
                                                            <input type="number" class="form-control border-0 bg-light"
                                                                x-model="current"
                                                                @focus="if (!cleared) { current = ''; cleared = true }"
                                                                @blur="if (current === '') { current = original; cleared = false }"
                                                                placeholder="Tab index" id="tab-{{ $index }}">
                                                            <label for="tab-{{ $index }}" class="text-muted">Tab
                                                                index</label>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="py-3 px-4 text-center">
                                                    <div class="form-check form-switch d-flex justify-content-center">
                                                        <input type="checkbox"
                                                            class="form-check-input form-check-input-lg"
                                                            wire:model="fields.{{ $index }}.always_required"
                                                            wire:change="onAlwaysRequiredChange({{ $index }})"
                                                            id="locked-{{ $index }}">
                                                        <label class="form-check-label ms-2"
                                                            for="locked-{{ $index }}"></label>
                                                    </div>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-center py-5">
                                                    <div class="text-muted">
                                                        <i class="bx bx-inbox bx-lg mb-3"></i>
                                                        <p class="mb-0">No fields found for this form.</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <div class="text-muted small">
                            <i class="bx bx-info-circle me-1"></i>
                            Configure field visibility, requirements, and tab order for better user experience
                        </div>
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                <i class="bx bx-x me-2"></i>Cancel
                            </button>
                            <button class="btn btn-primary shadow-sm" wire:click="save" wire:loading.attr="disabled">
                                <span wire:loading.remove>
                                    <i class="bx bx-device-floppy me-2"></i>Save Changes
                                </span>
                                <span wire:loading>
                                    <i class="bx bx-loader-alt bx-spin me-2"></i>Saving...
                                </span>
                            </button>
                        </div>
                    </div>

                    <!-- Success Message -->
                    @if (session()->has('success'))
                        <div class="alert alert-success border-0 shadow-sm mt-4 d-flex align-items-center">
                            <i class="bx bx-check-circle text-success me-2"></i>
                            {{ session('success') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

</div>
