<ul class="list-group list-group-flush p-0 m-0" style="min-width: 220px;">
    @foreach ($balances as $balance)
        @php
            $value = $balance['balance'] ?? 0;
            $currency = $balance['currency'] ?? 'USD';
            $label = $balance['label'] ?? ($value < 0 ? 'لنا' : 'علينا');
            $color = $value < 0 ? 'success' : 'danger';
            $icon = $value < 0 ? 'ti ti-arrow-up-right' : 'ti ti-arrow-down-right';
        @endphp

        <li class="list-group-item d-flex align-items-center justify-content-between gap-2">
            <div class="d-flex align-items-center gap-2">
                <i class="{{ $icon }} text-{{ $color }}"></i>
                <span class="text-body fw-semibold">{{ $label }}</span>
            </div>
            <span class="badge bg-label-{{ $color }}">

                {!! PriceFormat(abs($value), $currency) !!}
            </span>
        </li>
    @endforeach
    @php
        $baseColor = $basebalance < 0 ? 'success' : ($basebalance > 0 ? 'danger' : 'secondary');
        $baseIcon =
            $basebalance < 0
                ? 'ti ti-arrow-up-right'
                : ($basebalance > 0
                    ? 'ti ti-arrow-down-right'
                    : 'ti ti-arrows-left-right');
        $baseLabel = $basebalance < 0 ? 'لنا' : ($basebalance > 0 ? 'علينا' : 'متوازن');
    @endphp

    @if (!is_null($basebalance))
        <li class="list-group-item d-flex align-items-center justify-content-between gap-2">
            <div class="d-flex align-items-center gap-2">
                <i class="{{ $baseIcon }} text-{{ $baseColor }}"></i>
                <span class="text-body fw-semibold">الرصيد المقوم ({{ $baseLabel }})</span>
            </div>
            <span class="badge bg-label-{{ $baseColor }}">
                {!! PriceFormat(abs($basebalance), $basecurrency ?? 'USD') !!}
            </span>
        </li>
    @endif

    @if ($limit)
        <li class="list-group-item text-muted small d-flex justify-content-between align-items-center">
            <i class="ti ti-lock text-warning me-2"></i>
            <span>حد المديونية:</span>
            <span class="fw-bold ms-auto">{{ number_format($limit) }}</span>
        </li>
    @endif
</ul>
