<div wire:ignore x-data="{
    select2Instance: null,
    currentValue: @entangle($attributes->wire('model')),
    searchUrl: @entangle('searchUrl'),
    statusClasses: {
        'active': 'text-green-600',
        'expired': 'text-red-600',
        'no-contract': 'text-gray-500'
    },

    init() {
        this.$nextTick(() => {
            this.initSelect2();
        });

        this.$watch('currentValue', (value) => {
            if (this.select2Instance && value !== undefined) {
                this.select2Instance.val(value).trigger('change');
            }
        });

        // ✅ Watch for dynamic URL change
        this.$watch('searchUrl', (newUrl) => {
            this.destroy();
            this.initSelect2();
        });

        Livewire.on('refresh-select2', (dataArray) => {
            dataArray.forEach(data => {
                if (data.target === '{{ $attributes->wire('model')->value() }}') {
                    this.refreshOptions(data.options);
                }
            });
        });
    },

    initSelect2() {
        const placeholder = '{{ $attributes->get('placeholder', 'Select Option') }}';
        const modelName = '{{ $attributes->wire('model')->value() }}';
        const isDynamic = this.searchUrl && this.searchUrl.length > 0;
        const searchUrl = this.searchUrl;

        const options = {
            placeholder: placeholder,
            minimumResultsForSearch: 0,
            dropdownParent: $(this.$refs.select).closest('.select2_content'),
            width: '100%',
            templateResult: this.formatOption.bind(this),
            templateSelection: this.formatSelection.bind(this),
            escapeMarkup: m => m
        };

        if (isDynamic) {
            options.ajax = {
                url: searchUrl,
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        search: params.term,
                        page: params.page || 1
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.results,
                        pagination: {
                            more: data.pagination?.more || false
                        }
                    };
                },
                cache: true
            };

            options.minimumInputLength = 2;
        }

        this.select2Instance = $(this.$refs.select).select2(options);

        this.select2Instance.on('change', () => {
            const value = this.select2Instance.val();
            this.currentValue = value;
            @this.set(modelName, value, true);
        });

        // Prefill selected value for dynamic mode
        if (isDynamic && this.currentValue) {
            axios.get(searchUrl, {
                params: { id: this.currentValue }
            }).then(response => {
                const option = response.data.result;
                if (option) {
                    const newOption = new Option(option.text, option.id, true, true);
                    $(this.$refs.select).append(newOption).trigger('change');
                }
            });
        } else if (this.currentValue) {
            this.select2Instance.val(this.currentValue).trigger('change');
        }

        // Optional: prevent modal close when clicking
        if (this.$refs.select.hasAttribute('data-prevent-modal-close')) {
            $(document).on('click', '.select2-container--open', function(e) {
                e.stopPropagation();
            });
        }
    },

    formatOption(option) {
        if (!option.id) return option.text;
        const status = $(option.element).data('status') || option.status;
        const statusClass = this.statusClasses[status] || '';
        return $('<span>').addClass(statusClass).text(option.text);
    },

    formatSelection(option) {
        if (!option.id) return option.text;

        // Handle both DOM and AJAX objects
        const status = option.status || (option.element ? $(option.element).data('status') : null) || 'no-contract';
        const statusClass = this.statusClasses[status] || '';

        return $('<span>').addClass(statusClass).text(option.text);
    },

    refreshOptions(options) {
        const currentValue = this.currentValue;

        if (this.select2Instance) {
            this.select2Instance.select2('destroy');
        }

        const select = this.$refs.select;
        select.innerHTML = '';

        const defaultOption = document.createElement('option');
        defaultOption.value = '';
        defaultOption.textContent = '{{ $attributes->get('placeholder', 'Select Option') }}';
        select.appendChild(defaultOption);

        options.forEach(option => {
            const opt = document.createElement('option');
            opt.value = option.id;
            opt.textContent = option.text;
            opt.dataset.status = option.status || 'no-contract';
            opt.selected = (option.id == currentValue);
            select.appendChild(opt);
        });

        this.initSelect2();
    },

    destroy() {
        if (this.select2Instance) {
            this.select2Instance.off('change').select2('destroy');
        }
    }
}">
    <select x-ref="select" {{ $attributes->merge(['class' => 'form-control'])->except('wire:model') }}>
        {{ $slot }}
    </select>
</div>
