@props([
    'error' => null,
    'min' => null,
    'max' => null, // if null → no maxDate limit
])
<div x-data="{
    value: @entangle($attributes->wire('model')),
    min: @js($min),
    max: @js($max),
    init() {
        const today = new Date().toLocaleDateString('en-CA'); // YYYY-MM-DD local time

        const options = {
            enableTime: false,
            dateFormat: 'Y-m-d',
            defaultDate: this.value || today,
            onChange: (selectedDates, dateStr) => {
                this.value = dateStr;
            }
        };

        if (this.min) options.minDate = this.min;
        if (this.max) options.maxDate = this.max;

        const picker = flatpickr(this.$refs.input, options);

        if (!this.value) {
            this.value = picker.selectedDates[0]?.toLocaleDateString('en-CA') || today;
        }
    }
}">
    <input {{ $attributes->whereDoesntStartWith('wire:model') }} x-ref="input" x-bind:value="value"
        type="text" class="form-control" />
</div>
