<div wire:ignore x-data="{
    select2Instance: null,
    currentValue: @entangle($attributes->wire('model')),
    searchUrl: '{{ $attributes->get('search-url') }}',
    statusClasses: {
        'active': 'text-green-600',
        'expired': 'text-red-600',
        'no-contract': 'text-gray-500'
    },
    lastParams: null,
    loadingMore: false,
    currentPage: 1,
    dynamicParams: @entangle($attributes->wire('dynamic-params')).defer,
    hasInitialLoad: false,
    selectedOption: null,

    formatOption(option) {
        if (!option.id) return option.text;
        const status = $(option.element).data('status') || option.status;
        const statusClass = this.statusClasses[status] || '';
        return $('<span>').addClass(statusClass).text(option.text);
    },

    formatSelection(option) {
        if (!option.id) return option.text;
        const status = $(option.element).data('status') || option.status;
        const statusClass = this.statusClasses[status] || '';
        return $('<span>').addClass(statusClass).text(option.text);
    },

    init() {
        this.$nextTick(() => {
            this.initSelect2();

            // Load initial value immediately if it exists
            if (this.currentValue) {
                this.loadSelectedOption(this.currentValue);
            }
        });

        this.$watch('currentValue', (value) => {
            if (value && !this.selectedOption) {
                this.loadSelectedOption(value);
            }
            if (this.select2Instance && value !== undefined) {
                this.select2Instance.val(value).trigger('change');
            }
        });

        this.$watch('dynamicParams', (newParams) => {
            if (newParams && this.select2Instance) {
                this.destroy();
                this.initSelect2();
            }
        });

        Livewire.on('refresh-select2', (dataArray) => {
            dataArray.forEach(data => {
                if (data.target === '{{ $attributes->wire('model')->value() }}') {
                    this.refreshOptions(data.options);
                }
            });
        });
    },

    loadSelectedOption(value) {
        if (!value || !this.searchUrl) return;

        const url = `${this.searchUrl}${this.searchUrl.includes('?') ? '&' : '?'}id=${value}`;

        axios.get(url)
            .then(response => {
                const option = response.data.results?.[0];
                if (option) {
                    this.selectedOption = option;
                    this.updateSelect2Value(option);
                }
            })
            .catch(error => {
                console.error('Error loading selected option:', error);
            });
    },

    updateSelect2Value(option) {
        if (!this.select2Instance) return;

        // Clear existing options
        this.select2Instance.empty();

        // Add the new option
        const newOption = new Option(option.text, option.id, true, true);
        this.select2Instance.append(newOption).trigger('change');

        // Ensure the display updates
        this.select2Instance.trigger('change.select2');
    },

    initSelect2() {
        const placeholder = '{{ $attributes->get('placeholder', 'Select Option') }}';
        const modelName = '{{ $attributes->wire('model')->value() }}';
        const isDynamic = this.searchUrl && this.searchUrl.length > 0;

        let finalUrl = this.searchUrl;
        if (this.dynamicParams) {
            const queryString = new URLSearchParams(this.dynamicParams).toString();
            finalUrl = `${this.searchUrl}${this.searchUrl.includes('?') ? '&' : '?'}${queryString}`;
        }

        const options = {
            placeholder: placeholder,
            dropdownParent: $(this.$refs.select).closest('.select2_content') || document.body,
            width: '100%',
            templateResult: (option) => this.formatOption(option),
            templateSelection: (option) => this.formatSelection(option),
            escapeMarkup: m => m,
            allowClear: {{ $attributes->has('allow-clear') ? 'true' : 'false' }},
            minimumInputLength: 0,
            dropdownCssClass: 'force-initial-load'
        };

        if (isDynamic) {
            options.ajax = {
                url: finalUrl,
                dataType: 'json',
                delay: 250,
                data: (params) => {
                    this.lastParams = params;
                    this.currentPage = params.page || 1;
                    return {
                        search: params.term || '',
                        page: this.currentPage,
                        per_page: 10,
                        ...(this.dynamicParams || {})
                    };
                },
                processResults: (data, params) => {
                    params.page = params.page || 1;

                    if (this.loadingMore && this.select2Instance) {
                        const currentData = this.select2Instance.select2('data');
                        data.results = [...currentData, ...data.results];
                    }

                    this.loadingMore = false;
                    this.hasInitialLoad = true;

                    return {
                        results: data.results,
                        pagination: {
                            more: data.pagination?.more || false
                        }
                    };
                },
                cache: true
            };
        }

        this.select2Instance = $(this.$refs.select).select2(options);

        // Force initial load on first open
        $(this.$refs.select).on('select2:opening', () => {
            if (!this.hasInitialLoad && isDynamic) {
                this.$nextTick(() => {
                    this.select2Instance.select2('search', '');
                });
            }
        });

        // Infinite scroll
        $(this.$refs.select).on('select2:open', () => {
            const dropdown = $('.select2-container--open .select2-dropdown');
            dropdown.off('scroll').on('scroll', () => {
                const scrollTop = dropdown.scrollTop();
                const scrollHeight = dropdown.prop('scrollHeight');
                const clientHeight = dropdown.innerHeight();

                if (scrollHeight - (scrollTop + clientHeight) < 50) {
                    const select2Data = $(this.$refs.select).data('select2');
                    if (select2Data?.options?.options?.ajax) {
                        const pagination = select2Data.dataAdapter.current((data) => data.pagination || {});
                        if (pagination.more && !this.loadingMore) {
                            this.loadingMore = true;
                            this.currentPage++;
                            this.lastParams.page = this.currentPage;
                            select2Data.dataAdapter.ajax(this.lastParams);
                        }
                    }
                }
            });
        });

        this.select2Instance.on('change', () => {
            const value = this.select2Instance.val();
            this.currentValue = value;
            @this.set(modelName, value, true);
        });

        // Set initial value if it exists
        if (this.currentValue) {
            this.$nextTick(() => {
                this.select2Instance.val(this.currentValue).trigger('change');
            });
        }
    },

    refreshOptions(options) {
        if (this.select2Instance) {
            this.select2Instance.select2('destroy');
        }

        const select = this.$refs.select;
        select.innerHTML = '';

        const defaultOption = document.createElement('option');
        defaultOption.value = '';
        defaultOption.textContent = '{{ $attributes->get('placeholder', 'Select Option') }}';
        select.appendChild(defaultOption);

        options.forEach(option => {
            const opt = document.createElement('option');
            opt.value = option.id;
            opt.textContent = option.text;
            opt.dataset.status = option.status || 'no-contract';
            opt.selected = (option.id == this.currentValue);
            select.appendChild(opt);
        });

        this.hasInitialLoad = false;
        this.initSelect2();
    },

    destroy() {
        if (this.select2Instance) {
            this.select2Instance.off('change').select2('destroy');
        }
    }
}">
    <select x-ref="select"
        {{ $attributes->merge(['class' => 'form-control'])->except(['wire:model', 'search-url', 'dynamic-params']) }}>
        <option value=""></option>
        {{ $slot }}
    </select>
</div>

<style>
    .select2-container--force-initial-load .select2-dropdown {
        display: block !important;
    }
</style>
