<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Charity Module Documentation Routes
|--------------------------------------------------------------------------
|
| These routes are for the charity module documentation section.
|
*/

Route::prefix('charity-module')->group(function () {
    Route::get('/', function () {
        return view('charity-module.overview');
    })->name('charity.overview');

    Route::get('/requirements', function () {
        return view('charity-module.requirements');
    })->name('charity.requirements');

    Route::get('/database-schema', function () {
        return view('charity-module.database_schema');
    })->name('charity.database');

    Route::get('/business-logic', function () {
        return view('charity-module.business_logic');
    })->name('charity.business-logic');

    Route::get('/frontend-design', function () {
        return view('charity-module.frontend_design');
    })->name('charity.frontend');

    Route::get('/user-flows', function () {
        return view('charity-module.user_flows');
    })->name('charity.user-flows');

    Route::get('/summary', function () {
        return view('charity-module.summary');
    })->name('charity.summary');
});
