@extends('layouts.charity-module')

@section('title', 'Requirements Analysis')

@section('content')
<div class="row">
    <div class="col-12">
        <h1>Charity Module Requirements Analysis</h1>
        
        <div class="card">
            <div class="card-body">
                <h2>Overview</h2>
                <p>The charity module is being developed for a foundation (vakıf) that manages over 700 properties (mulk) and supports more than 450 beneficiaries (evlat). The foundation already has a system for collecting rent, managing deposits, and distributing income using the Bavix wallet package in Laravel with Livewire. The new charity module will extend this functionality to handle charitable activities.</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Current System Understanding</h4>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-primary mr-1"></span>
                        The foundation uses multiple wallets to segregate funds (rent money, deposits, etc.)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-primary mr-1"></span>
                        Income distribution follows Islamic principles (male 2, female 1)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-primary mr-1"></span>
                        Donation system is already implemented with conditional and unconditional donations
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-primary mr-1"></span>
                        Vuexy template is used for the frontend
                    </li>
                </ul>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Donation Structure (Existing)</h4>
            </div>
            <div class="card-body">
                <p>Based on the provided schema:</p>
                <div class="bg-light-secondary p-1 rounded">
                    <pre><code>Schema::create('donations', function (Blueprint $table) {
    $table->id();
    $table->string('donor_name')->nullable();
    $table->float('amount');
    $table->integer('currency')->default(1);
    $table->date('donation_date');
    $table->foreignId('account_id')->nullable()->constrained('accounts')->onDelete('cascade');
    $table->text('notes')->nullable();
    $table->enum('type', ['conditional', 'unconditional'])->default('unconditional');
    $table->foreignId('payment_method_id')->nullable()->constrained('paymentmethods')->onDelete('set null');
    $table->foreignId('category_id')->nullable()->constrained('expense_categories')->onDelete('set null');
    $table->foreignId('subcategory_id')->nullable()->constrained('expense_subcategories')->onDelete('cascade');
    $table->integer("transaction_id");
    $table->timestamps();
});</code></pre>
                </div>

                <h5 class="mt-2">The donation system tracks:</h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Donor information
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Amount and currency
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Donation date
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Associated account
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Donation type (conditional/unconditional)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Payment method
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Categorization (category and subcategory)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-info mr-1"></span>
                        Transaction reference
                    </li>
                </ul>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Charity Module Requirements</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">1. Budget Management</h5>
                                <ul>
                                    <li>The foundation needs independent charity budgets for different purposes (e.g., Ramadan budget: 100,000, Student budget: 200,000)</li>
                                    <li>Each budget should be tracked separately</li>
                                    <li>Budgets may be funded from foundation's general funds or from specific donations</li>
                                    <li>Budget allocation should be trackable and reportable</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">2. Donation Integration</h5>
                                <ul>
                                    <li>Conditional donations need to be directed to appropriate charity budgets</li>
                                    <li>Unconditional donations should be allocatable to any charity budget at foundation's discretion</li>
                                    <li>Clear tracking of which donations fund which charity activities</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-danger">
                            <div class="card-body">
                                <h5 class="card-title">3. Disbursement Management</h5>
                                <ul>
                                    <li>Process for approving and tracking charity disbursements</li>
                                    <li>Ability to categorize disbursements by purpose/category</li>
                                    <li>Tracking of beneficiaries receiving charity</li>
                                    <li>Documentation of disbursement details (date, amount, purpose, etc.)</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">4. Reporting Requirements</h5>
                                <ul>
                                    <li>Budget utilization reports</li>
                                    <li>Donation allocation reports</li>
                                    <li>Disbursement activity reports</li>
                                    <li>Beneficiary support reports</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <h5 class="card-title">5. Wallet Integration</h5>
                                <ul>
                                    <li>Integration with existing Bavix wallet system</li>
                                    <li>Possible need for dedicated charity wallets</li>
                                    <li>Transaction tracking between wallets</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-secondary">
                            <div class="card-body">
                                <h5 class="card-title">6. User Interface Requirements</h5>
                                <ul>
                                    <li>Budget management interface</li>
                                    <li>Disbursement request and approval workflow</li>
                                    <li>Reporting dashboards</li>
                                    <li>Integration with existing Vuexy template</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Key Entities Needed</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Entity</th>
                                <th>Purpose</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Charity Budgets</td>
                                <td>Track different charity funds with targets and utilization</td>
                            </tr>
                            <tr>
                                <td>Budget Allocations</td>
                                <td>Track funding sources (donations or foundation funds)</td>
                            </tr>
                            <tr>
                                <td>Charity Disbursements</td>
                                <td>Track how funds are distributed to beneficiaries</td>
                            </tr>
                            <tr>
                                <td>Charity Beneficiaries</td>
                                <td>Track recipients of charity (if different from existing evlat)</td>
                            </tr>
                            <tr>
                                <td>Disbursement Categories</td>
                                <td>Categorize different types of charitable disbursements</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Relationships with Existing System</h4>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-success mr-1"></span>
                        Donations → Charity Budgets (funding source)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-success mr-1"></span>
                        Accounts → Charity Budgets (funding source)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-success mr-1"></span>
                        Charity Budgets → Disbursements (expense tracking)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-success mr-1"></span>
                        Expense Categories → Charity Budgets (categorization)
                    </li>
                    <li class="list-group-item d-flex align-items-center">
                        <span class="bullet bullet-success mr-1"></span>
                        Expense Categories → Disbursements (categorization)
                    </li>
                </ul>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Special Considerations</h4>
            </div>
            <div class="card-body">
                <div class="alert alert-primary" role="alert">
                    <div class="alert-body">
                        <strong>Conditional Donations:</strong> Need to handle conditional donations appropriately
                    </div>
                </div>
                <div class="alert alert-warning" role="alert">
                    <div class="alert-body">
                        <strong>Accounting & Audit:</strong> Need to ensure proper accounting and audit trail
                    </div>
                </div>
                <div class="alert alert-info" role="alert">
                    <div class="alert-body">
                        <strong>Reporting:</strong> Need to provide clear reporting on budget utilization
                    </div>
                </div>
                <div class="alert alert-success" role="alert">
                    <div class="alert-body">
                        <strong>Wallet Integration:</strong> Integration with existing wallet system for fund transfers
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
