<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Charity Module Documentation - @yield('title')</title>
    <!-- Vuexy CSS -->
    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap-extended.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/colors.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/components.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/themes/dark-layout.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/themes/bordered-layout.css') }}">
    <link rel="stylesheet" href="{{ asset('app-assets/css/themes/semi-dark-layout.css') }}">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <style>
        .charity-docs-sidebar {
            padding: 1.5rem;
        }
        .charity-docs-sidebar .nav-link {
            padding: 0.5rem 1rem;
            border-radius: 0.25rem;
        }
        .charity-docs-sidebar .nav-link.active {
            background-color: rgba(115, 103, 240, 0.12);
            color: #7367f0;
        }
        .charity-docs-content {
            padding: 1.5rem;
        }
        .charity-docs-content h1 {
            margin-bottom: 1.5rem;
            color: #5e5873;
        }
        .charity-docs-content h2 {
            margin-top: 2rem;
            margin-bottom: 1rem;
            color: #5e5873;
        }
        .charity-docs-content h3 {
            margin-top: 1.5rem;
            margin-bottom: 0.75rem;
            color: #5e5873;
        }
        .charity-docs-content pre {
            background-color: #283046;
            color: #b4b7bd;
            padding: 1rem;
            border-radius: 0.25rem;
            margin-bottom: 1.5rem;
            overflow-x: auto;
        }
        .charity-docs-content code {
            background-color: #283046;
            color: #b4b7bd;
            padding: 0.2rem 0.4rem;
            border-radius: 0.25rem;
        }
        .charity-docs-content table {
            width: 100%;
            margin-bottom: 1.5rem;
        }
        .charity-docs-content table th,
        .charity-docs-content table td {
            padding: 0.75rem;
            border-bottom: 1px solid #3b4253;
        }
        .charity-docs-content table th {
            background-color: #283046;
            color: #d0d2d6;
        }
    </style>
</head>
<body class="vertical-layout vertical-menu-modern navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="">
    <!-- BEGIN: Header-->
    <nav class="header-navbar navbar navbar-expand-lg align-items-center floating-nav navbar-light navbar-shadow">
        <div class="navbar-container d-flex content">
            <div class="bookmark-wrapper d-flex align-items-center">
                <ul class="nav navbar-nav d-xl-none">
                    <li class="nav-item"><a class="nav-link menu-toggle" href="javascript:void(0);"><i class="ficon" data-feather="menu"></i></a></li>
                </ul>
                <ul class="nav navbar-nav">
                    <li class="nav-item d-none d-lg-block">
                        <h2 class="mb-0">Charity Module Documentation</h2>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- END: Header-->

    <!-- BEGIN: Main Menu-->
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item mr-auto">
                    <a class="navbar-brand" href="#">
                        <span class="brand-logo"></span>
                        <h2 class="brand-text">Charity Module</h2>
                    </a>
                </li>
                <li class="nav-item nav-toggle">
                    <a class="nav-link modern-nav-toggle pr-0" data-toggle="collapse">
                        <i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i>
                        <i class="d-none d-xl-block collapse-toggle-icon font-medium-4 text-primary" data-feather="disc" data-ticon="disc"></i>
                    </a>
                </li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <div class="main-menu-content charity-docs-sidebar">
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class="nav-item {{ request()->is('charity-module') ? 'active' : '' }}">
                    <a class="d-flex align-items-center" href="{{ route('charity-module.overview') }}">
                        <i data-feather="home"></i>
                        <span class="menu-title text-truncate">Overview</span>
                    </a>
                </li>
                <li class="nav-item {{ request()->is('charity-module/requirements') ? 'active' : '' }}">
                    <a class="d-flex align-items-center" href="{{ route('charity-module.requirements') }}">
                        <i data-feather="clipboard"></i>
                        <span class="menu-title text-truncate">Requirements Analysis</span>
                    </a>
                </li>
                <li class="nav-item {{ request()->is('charity-module/database') ? 'active' : '' }}">
                    <a class="d-flex align-items-center" href="{{ route('charity-module.database') }}">
                        <i data-feather="database"></i>
                        <span class="menu-title text-truncate">Database Schema</span>
                    </a>
                </li>
                <li class="nav-item {{ request()->is('charity-module/business-logic') ? 'active' : '' }}">
                    <a class="d-flex align-items-center" href="{{ route('charity-module.business-logic') }}">
                        <i data-feather="settings"></i>
                        <span class="menu-title text-truncate">Business Logic</span>
                    </a>
                </li>
                <li class="nav-item {{ request()->is('charity-module/frontend-design') ? 'active' : '' }}">
                    <a class="d-flex align-items-center" href="{{ route('charity-module.frontend-design') }}">
                        <i data-feather="layout"></i>
                        <span class="menu-title text-truncate">Frontend Design</span>
                    </a>
                </li>
                <li class="nav-item {{ request()->is('charity-module/user-flows') ? 'active' : '' }}">
                    <a class="d-flex align-items-center" href="{{ route('charity-module.user-flows') }}">
                        <i data-feather="users"></i>
                        <span class="menu-title text-truncate">User Flows & Wireframes</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">@yield('title')</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('charity-module.overview') }}">Charity Module</a></li>
                                    <li class="breadcrumb-item active">@yield('title')</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body charity-docs-content">
                                @yield('content')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        <p class="clearfix mb-0">
            <span class="float-md-left d-block d-md-inline-block mt-25">
                Mulk Takibi Project - Charity Module Documentation
            </span>
        </p>
    </footer>
    <!-- END: Footer-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ asset('app-assets/vendors/js/vendors.min.js') }}"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ asset('app-assets/js/core/app-menu.js') }}"></script>
    <script src="{{ asset('app-assets/js/core/app.js') }}"></script>
    <!-- END: Theme JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });
    </script>
</body>
</html>
