# Charity Module Documentation - Integration Guide

This guide explains how to integrate the charity module documentation into your existing Laravel project with Vuexy template.

## Prerequisites

- Laravel project with Vuexy template installed
- Basic knowledge of Laravel routing and Blade templates

## Integration Steps

### 1. Copy Blade Files

1. Create a directory structure in your Laravel project:

```
resources/
└── views/
    └── charity-module/
```

2. Copy all the Blade files from this package to the `resources/views/charity-module/` directory:

```bash
cp -r /path/to/package/*.blade.php /path/to/your-project/resources/views/charity-module/
```

3. Create the layouts directory and copy the layout file:

```bash
mkdir -p /path/to/your-project/resources/views/charity-module/layouts/
cp -r /path/to/package/layouts/charity-module.blade.php /path/to/your-project/resources/views/charity-module/layouts/
```

### 2. Add Routes

Add the following routes to your `routes/web.php` file:

```php
Route::prefix('charity-module')->group(function () {
    Route::get('/', function () {
        return view('charity-module.overview');
    })->name('charity.overview');

    Route::get('/requirements', function () {
        return view('charity-module.requirements');
    })->name('charity.requirements');

    Route::get('/database-schema', function () {
        return view('charity-module.database_schema');
    })->name('charity.database');

    Route::get('/business-logic', function () {
        return view('charity-module.business_logic');
    })->name('charity.business-logic');

    Route::get('/frontend-design', function () {
        return view('charity-module.frontend_design');
    })->name('charity.frontend');

    Route::get('/user-flows', function () {
        return view('charity-module.user_flows');
    })->name('charity.user-flows');

    Route::get('/summary', function () {
        return view('charity-module.summary');
    })->name('charity.summary');
});
```

### 3. Update Asset Paths

The Blade templates reference Vuexy assets using the `asset()` helper. Make sure your Vuexy assets are in the correct locations:

- CSS files should be in `public/app-assets/css/`
- JS files should be in `public/app-assets/js/`
- Vendor files should be in `public/app-assets/vendors/`

If your Vuexy assets are in different locations, update the paths in the `layouts/charity-module.blade.php` file.

### 4. Add Link to Main Navigation

Add a link to the charity module documentation in your main navigation:

```html
<li class="nav-item">
    <a class="nav-link" href="{{ route('charity.overview') }}">
        <i data-feather="book-open"></i>
        <span>Charity Module Docs</span>
    </a>
</li>
```

### 5. Test the Integration

Visit `http://your-app-url/charity-module` to ensure the documentation is properly integrated and styled.

## Customization

### Modifying the Layout

If you need to adjust the layout to match your specific Vuexy implementation:

1. Edit the `layouts/charity-module.blade.php` file
2. Update the header, footer, and navigation sections as needed
3. Ensure all asset paths are correct for your environment

### Adding Additional Content

To add more documentation pages:

1. Create a new Blade file in the `resources/views/charity-module/` directory
2. Add a new route in the `routes/web.php` file
3. Add a link to the new page in the navigation menu in `layouts/charity-module.blade.php`

## Troubleshooting

### Missing Styles or JavaScript

If styles or JavaScript are not loading:

1. Check browser console for errors
2. Verify asset paths in the layout file
3. Ensure Vuexy assets are correctly installed in your project

### Navigation Links Not Working

If navigation links are broken:

1. Check that all routes are properly defined
2. Verify that route names match those used in the navigation links
3. Clear route cache with `php artisan route:clear`

## Support

For any issues with the integration, please contact the development team.
