@extends('layouts.charity-module')

@section('title', 'Frontend Design')

@section('content')
<div class="row">
    <div class="col-12">
        <h1>Charity Module Frontend Design with Vuexy Template</h1>
        
        <div class="card">
            <div class="card-body">
                <h2>Overview</h2>
                <p>This section outlines the frontend design for the charity module using the Vuexy template. The design focuses on creating intuitive interfaces for managing charity budgets, allocations, disbursements, and reporting while maintaining consistency with the existing application design.</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Design Principles</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Consistency</h5>
                                    </div>
                                    <div class="avatar bg-primary p-50">
                                        <div class="avatar-content">
                                            <i data-feather="check-circle" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Maintain the same look and feel as the rest of the application</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Responsive</h5>
                                    </div>
                                    <div class="avatar bg-info p-50">
                                        <div class="avatar-content">
                                            <i data-feather="smartphone" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Ensure all screens work well on both desktop and mobile devices</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Intuitive</h5>
                                    </div>
                                    <div class="avatar bg-success p-50">
                                        <div class="avatar-content">
                                            <i data-feather="compass" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Create clear navigation paths for different user roles</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h5 class="mb-0">Visual</h5>
                                    </div>
                                    <div class="avatar bg-warning p-50">
                                        <div class="avatar-content">
                                            <i data-feather="bar-chart-2" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                </div>
                                <p class="mt-1">Use charts and graphs for better understanding of charity activities</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Navigation Structure</h4>
            </div>
            <div class="card-body">
                <p>The charity module adds a new "Charity" section to the main sidebar navigation with the following sub-items:</p>
                <div class="row">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar bg-light-primary p-50 mr-1">
                                        <div class="avatar-content">
                                            <i data-feather="home" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Dashboard</h5>
                                        <small>Charity overview and metrics</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar bg-light-success p-50 mr-1">
                                        <div class="avatar-content">
                                            <i data-feather="dollar-sign" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Budgets</h5>
                                        <small>Manage charity budgets</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar bg-light-info p-50 mr-1">
                                        <div class="avatar-content">
                                            <i data-feather="trending-up" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Allocations</h5>
                                        <small>Manage fund allocations</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar bg-light-warning p-50 mr-1">
                                        <div class="avatar-content">
                                            <i data-feather="credit-card" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Disbursements</h5>
                                        <small>Manage disbursements</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar bg-light-danger p-50 mr-1">
                                        <div class="avatar-content">
                                            <i data-feather="users" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Beneficiaries</h5>
                                        <small>Manage charity recipients</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="avatar bg-light-secondary p-50 mr-1">
                                        <div class="avatar-content">
                                            <i data-feather="bar-chart" class="font-medium-4"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Reports</h5>
                                        <small>View charity reports</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Key Screen Designs</h4>
            </div>
            <div class="card-body">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="dashboard-tab" data-toggle="tab" href="#dashboard" aria-controls="dashboard" role="tab" aria-selected="true">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="budgets-tab" data-toggle="tab" href="#budgets" aria-controls="budgets" role="tab" aria-selected="false">Budgets</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="disbursements-tab" data-toggle="tab" href="#disbursements" aria-controls="disbursements" role="tab" aria-selected="false">Disbursements</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="reports-tab" data-toggle="tab" href="#reports" aria-controls="reports" role="tab" aria-selected="false">Reports</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="dashboard" aria-labelledby="dashboard-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Charity Dashboard</h5>
                                <p>The dashboard provides an overview of charity activities and key metrics.</p>
                                
                                <h6 class="mt-2">Components:</h6>
                                <ul>
                                    <li><strong>Header Section</strong>: Title and quick action buttons</li>
                                    <li><strong>Summary Cards Row</strong>: Total Active Budgets, Total Allocated This Month, Total Disbursed This Month, Pending Disbursement Requests</li>
                                    <li><strong>Budget Utilization Chart</strong>: Horizontal bar chart showing target vs. current vs. disbursed amounts for top 5 budgets</li>
                                    <li><strong>Recent Activity Timeline</strong>: Timeline showing recent allocations and disbursements</li>
                                    <li><strong>Disbursement Status Donut Chart</strong>: Shows distribution of disbursements by status</li>
                                    <li><strong>Upcoming Budget Deadlines</strong>: Table showing budgets with end dates approaching</li>
                                </ul>
                                
                                <div class="alert alert-info mt-2">
                                    <div class="alert-body">
                                        <p>The dashboard uses Vuexy Card components with statistics, Timeline component, Charts (Bar chart, Donut chart), and Data Tables.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="budgets" aria-labelledby="budgets-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Budgets Management</h5>
                                <p>The budgets screen allows users to manage charity budgets.</p>
                                
                                <h6 class="mt-2">Components:</h6>
                                <ul>
                                    <li><strong>Header Section</strong>: Title, "New Budget" button, search and filter options</li>
                                    <li><strong>Budgets Data Table</strong>: Columns for Name, Description, Target Amount, Current Amount, Disbursed Amount, % Utilized, Start Date, End Date, Status, Actions</li>
                                    <li><strong>Budget Details Sidebar</strong>: Slides in when "View" is clicked, shows complete budget details with tabs for Overview, Allocations, Disbursements, Documents</li>
                                </ul>
                                
                                <h6 class="mt-2">New/Edit Budget Form:</h6>
                                <ul>
                                    <li><strong>Form Card</strong>: With fields for Name, Description, Target Amount, Start Date, End Date, Category, Wallet, Status</li>
                                    <li><strong>Action buttons</strong>: "Save", "Cancel"</li>
                                </ul>
                                
                                <div class="alert alert-info mt-2">
                                    <div class="alert-body">
                                        <p>The budgets screen uses Vuexy Data Tables with search and filters, Sidebar component, Tabs component, Form elements, and Progress bars for utilization.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="disbursements" aria-labelledby="disbursements-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Disbursements Management</h5>
                                <p>The disbursements screen allows users to manage charity disbursements.</p>
                                
                                <h6 class="mt-2">Components:</h6>
                                <ul>
                                    <li><strong>Header Section</strong>: Title, "New Disbursement" button, search and filter options</li>
                                    <li><strong>Status Filter Tabs</strong>: Quick filter tabs for All, Pending, Approved, Disbursed, Cancelled</li>
                                    <li><strong>Disbursements Data Table</strong>: Columns for Budget, Amount, Currency, Disbursement Date, Recipient, Purpose, Status, Requested By, Approved By, Actions</li>
                                    <li><strong>Disbursement Details Sidebar</strong>: Slides in when "View" is clicked, shows complete disbursement details with tabs for Overview, Beneficiaries, Documents, Approval History</li>
                                </ul>
                                
                                <h6 class="mt-2">New Disbursement Request Form:</h6>
                                <ul>
                                    <li><strong>Form Card</strong>: With fields for Budget, Amount, Disbursement Date, Recipient Name, Recipient Contact, Purpose, Category, Subcategory, Payment Method, Notes</li>
                                    <li><strong>Multiple Beneficiaries section</strong>: Optional table for distributing to multiple beneficiaries</li>
                                    <li><strong>Document Upload section</strong>: For attaching supporting documents</li>
                                    <li><strong>Action buttons</strong>: "Submit Request", "Save Draft", "Cancel"</li>
                                </ul>
                                
                                <div class="alert alert-info mt-2">
                                    <div class="alert-body">
                                        <p>The disbursements screen uses Vuexy Data Tables, Tabs component, Sidebar component, Form elements, File Upload component, and Repeater component for beneficiaries.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="reports" aria-labelledby="reports-tab" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Reports Dashboard</h5>
                                <p>The reports screen provides various charity reports and analytics.</p>
                                
                                <h6 class="mt-2">Components:</h6>
                                <ul>
                                    <li><strong>Header Section</strong>: Title, Report type selector (tabs), Date range filter, Export buttons</li>
                                    <li><strong>Report Types</strong>: Budget Utilization Report, Donation Allocation Report, Disbursement Activity Report, Beneficiary Support Report</li>
                                    <li><strong>Charts</strong>: Various charts depending on report type (bar charts, pie charts, line charts)</li>
                                    <li><strong>Data Tables</strong>: Detailed data tables with report data</li>
                                    <li><strong>Summary Statistics</strong>: Key metrics and totals</li>
                                </ul>
                                
                                <div class="alert alert-info mt-2">
                                    <div class="alert-body">
                                        <p>The reports screen uses Vuexy Card components, Charts (Bar, Line, Pie), Data Tables, Form elements for filters, Tabs component, and Export buttons.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Mobile Responsiveness</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">Dashboard</h5>
                                <ul>
                                    <li>Cards stack vertically on small screens</li>
                                    <li>Charts resize to fit screen width</li>
                                    <li>Tables become scrollable horizontally</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">Data Tables</h5>
                                <ul>
                                    <li>Less important columns hide on small screens</li>
                                    <li>Action buttons collapse into dropdown menu</li>
                                    <li>Filters collapse into expandable section</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">Forms</h5>
                                <ul>
                                    <li>Form fields stack vertically</li>
                                    <li>Full width inputs on small screens</li>
                                    <li>Simplified layouts for better mobile experience</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Color Scheme and Styling</h4>
            </div>
            <div class="card-body">
                <p>Following Vuexy's theming capabilities:</p>
                <div class="row">
                    <div class="col-md-6">
                        <h5>Primary Colors</h5>
                        <div class="d-flex mb-1">
                            <div class="avatar bg-primary p-50 mr-1">
                                <div class="avatar-content">&nbsp;</div>
                            </div>
                            <div class="d-flex align-items-center">
                                <span>Primary: #7367F0 (Vuexy default primary)</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="avatar bg-success p-50 mr-1">
                                <div class="avatar-content">&nbsp;</div>
                            </div>
                            <div class="d-flex align-items-center">
                                <span>Success: #28C76F (for approved/completed states)</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="avatar bg-danger p-50 mr-1">
                                <div class="avatar-content">&nbsp;</div>
                            </div>
                            <div class="d-flex align-items-center">
                                <span>Danger: #EA5455 (for rejected/cancelled states)</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="avatar bg-warning p-50 mr-1">
                                <div class="avatar-content">&nbsp;</div>
                            </div>
                            <div class="d-flex align-items-center">
                                <span>Warning: #FF9F43 (for pending states)</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="avatar bg-info p-50 mr-1">
                                <div class="avatar-content">&nbsp;</div>
                            </div>
                            <div class="d-flex align-items-center">
                                <span>Info: #00CFE8 (for informational elements)</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <h5>Status Colors</h5>
                        <div class="d-flex mb-1">
                            <div class="badge badge-warning mr-1">Pending</div>
                            <div class="d-flex align-items-center">
                                <span>Warning color</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="badge badge-info mr-1">Approved</div>
                            <div class="d-flex align-items-center">
                                <span>Info color</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="badge badge-success mr-1">Disbursed</div>
                            <div class="d-flex align-items-center">
                                <span>Success color</span>
                            </div>
                        </div>
                        <div class="d-flex mb-1">
                            <div class="badge badge-danger mr-1">Cancelled</div>
                            <div class="d-flex align-items-center">
                                <span>Danger color</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Accessibility Considerations</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">Color Contrast</h5>
                                <ul>
                                    <li>All text meets WCAG AA standards for contrast</li>
                                    <li>Don't rely solely on color to convey information</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">Keyboard Navigation</h5>
                                <ul>
                                    <li>All interactive elements are keyboard accessible</li>
                                    <li>Logical tab order throughout the interface</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">Screen Reader Support</h5>
                                <ul>
                                    <li>Proper ARIA labels for interactive elements</li>
                                    <li>Meaningful alt text for images and icons</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
