@php
    // Build buttons array based on your existing conditions
    $buttons = [];

    // Edit Button
    if ($data->status != 'reverse' && $data->status != 'deleted' && $data->status != 'cancelled') {
        if (auth()->user()->can('update', $data)) {
            $buttons[] = [
                'type' => 'link',
                'url' => "/Booking/{$data->id}/edit",
                'title' => __('actions.Edit'),
                'icon' => 'tf-icons ti ti-pencil',
                'class' => 'btn-text-secondary',
            ];
        }
    }

    // Delete Button
    if ($data->status != 'reverse' && $data->status != 'cancelled' && $data->status != 'deleted') {
        if (auth()->user()->can('delete', $data)) {
            $buttons[] = [
                'type' => 'button',
                'title' => __('actions.delete'),
                'icon' => 'tf-icons ti ti-trash',
                'class' => 'btn-text-secondary',
                'action' => 'DeleteTransferConfirm',
                'data' => ['transfer_id' => $data->id],
            ];
        }
    }

    // Show Audit (always visible)
    $buttons[] = [
        'type' => 'button',
        'title' => __('actions.ShowAudit'),
        'icon' => 'tf-icons ti ti-logs',
        'class' => 'btn-text-secondary',
        'action' => 'ShowAudit',
        'data' => ['model' => 'LedgerBooking', 'model_id' => $data->id],
    ];

    // Show Receipt
    if ($data->status != 'reverse') {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.ShowReceipt'),
            'icon' => 'tf-icons ti ti-eye',
            'class' => 'btn-text-secondary',
            'action' => 'ShowTransferReceipt',
            'data' => ['transfer_id' => $data->id, 'model' => 'LedgerBooking'],
        ];
    }

    // Cancel Button
    if (!$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted') {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.cancel'),
            'icon' => 'tf-icons ti ti-circle-x',
            'class' => 'btn-text-secondary',
            'action' => 'CancelTransferConfirm',
            'data' => ['transfer_id' => $data->id],
        ];
    }

    // Attachments (always visible)
    $buttons[] = [
        'type' => 'button',
        'title' => __('actions.Attachments'),
        'icon' => 'tf-icons ti ti-paperclip',
        'class' => 'btn-text-secondary',
        'action' => 'ShowTransferMedia',
        'data' => ['transfer_id' => $data->id, 'model' => 'LedgerBooking'],
    ];

    $buttonCount = count($buttons);
    $showDropdown = $buttonCount > 3; // Show dropdown if more than 3 buttons
@endphp

<div class="d-flex justify-content-around">
    @if ($showDropdown)
        {{-- Show first 2 buttons + dropdown for remaining --}}
        @foreach (array_slice($buttons, 0, 2) as $button)
            @if ($button['type'] === 'link')
                <a class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" href="{{ $button['url'] }}"
                    title="{{ $button['title'] }}">
                    <i class="{{ $button['icon'] }}"></i>
                </a>
            @else
                <button class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" title="{{ $button['title'] }}"
                    x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                    <i class="{{ $button['icon'] }}"></i>
                </button>
            @endif
        @endforeach

        {{-- Dropdown for remaining buttons --}}
        <div class="dropdown d-inline-block">
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" type="button" data-bs-toggle="dropdown"
                aria-expanded="false" title="{{ __('More Actions') }}">
                <i class="tf-icons ti ti-dots-vertical"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                @foreach (array_slice($buttons, 2) as $button)
                    <li>
                        @if ($button['type'] === 'link')
                            <a class="dropdown-item" href="{{ $button['url'] }}">
                                <i class="{{ $button['icon'] }} me-2"></i>
                                {{ $button['title'] }}
                            </a>
                        @else
                            <button class="dropdown-item"
                                x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                                <i class="{{ $button['icon'] }} me-2"></i>
                                {{ $button['title'] }}
                            </button>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    @else
        {{-- Show all buttons individually when ≤ 3 buttons --}}
        @foreach ($buttons as $button)
            @if ($button['type'] === 'link')
                <a class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" href="{{ $button['url'] }}"
                    title="{{ $button['title'] }}">
                    <i class="{{ $button['icon'] }}"></i>
                </a>
            @else
                <button class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" title="{{ $button['title'] }}"
                    x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                    <i class="{{ $button['icon'] }}"></i>
                </button>
            @endif
        @endforeach
    @endif
</div>
