@php
    // Build buttons array based on your existing conditions
    $buttons = [];

    // Edit Button
    if (
        !$data->isDelivered() &&
        !$data->isReversed() &&
        $data->status != 'cancelled' &&
        $data->status != 'deleted' &&
        $data->status != 'blocked'
    ) {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.Edit'),
            'icon' => 'tf-icons ti ti-pencil',
            'class' => 'btn-text-secondary',
            'action' => 'editApproval',
            'data' => ['id' => $data->id],
        ];

        $buttons[] = [
            'type' => 'link',
            'url' => "/Transfer/DeliverTransfer/{$data->id}",
            'title' => __('actions.DeliverTransfer'),
            'icon' => 'tf-icons ti ti-send-2',
            'class' => 'btn-text-secondary',
            'target' => '_blank',
        ];
    }

    // Show Audit (with permission check)
    if (auth()->user()->can('View Audits')) {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.ShowAudit'),
            'icon' => 'tf-icons ti ti-logs',
            'class' => 'btn-text-secondary',
            'action' => 'ShowAudit',
            'data' => ['model' => 'LedgerApproval', 'model_id' => $data->id],
        ];
    }

    // Show Receipt (always visible)
    $buttons[] = [
        'type' => 'button',
        'title' => __('actions.ShowReceipt'),
        'icon' => 'tf-icons ti ti-eye',
        'class' => 'btn-text-secondary',
        'action' => 'ShowTransferReceipt',
        'data' => ['transfer_id' => $data->id],
    ];

    // Cancel Button (only for non-agent users)
    if (!auth()->guard('agent')->check()) {
        if (
            !$data->isDelivered() &&
            !$data->isReversed() &&
            $data->status != 'cancelled' &&
            $data->status != 'deleted'
        ) {
            $buttons[] = [
                'type' => 'button',
                'title' => __('actions.cancel'),
                'icon' => 'tf-icons ti ti-circle-x',
                'class' => 'btn-text-secondary',
                'action' => 'CancelTransferConfirm',
                'data' => ['transfer_id' => $data->id],
            ];
        }
    }

    // Unblock Button
    if ($data->is_blocked && $data->status != 'completed' && $data->status != 'cancelled') {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.unblock'),
            'icon' => 'tf-icons ti ti-lock',
            'class' => 'btn-text-secondary',
            'action' => 'UnblockTransferConfirm',
            'data' => ['transfer_id' => $data->id],
        ];
    }

    // Block Button
    if (!$data->is_blocked && $data->status != 'completed' && $data->status != 'cancelled') {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.block'),
            'icon' => 'tf-icons ti ti-lock-open',
            'class' => 'btn-text-secondary',
            'action' => 'BlockTransferConfirm',
            'data' => ['transfer_id' => $data->id],
        ];
    }

    $buttonCount = count($buttons);
    $showDropdown = $buttonCount > 3; // Show dropdown if more than 3 buttons
@endphp

<div class="d-flex justify-content-around">
    @if ($showDropdown)
        {{-- Show first 2 buttons + dropdown for remaining --}}
        @foreach (array_slice($buttons, 0, 2) as $button)
            @if ($button['type'] === 'link')
                <a class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" href="{{ $button['url'] }}"
                    @if (isset($button['target'])) target="{{ $button['target'] }}" @endif
                    title="{{ $button['title'] }}">
                    <i class="{{ $button['icon'] }}"></i>
                </a>
            @else
                <button class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" title="{{ $button['title'] }}"
                    x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                    <i class="{{ $button['icon'] }}"></i>
                </button>
            @endif
        @endforeach

        {{-- Dropdown for remaining buttons --}}
        <div class="dropdown d-inline-block">
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" type="button" data-bs-toggle="dropdown"
                aria-expanded="false" title="{{ __('More Actions') }}">
                <i class="tf-icons ti ti-dots-vertical"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                @foreach (array_slice($buttons, 2) as $button)
                    <li>
                        @if ($button['type'] === 'link')
                            <a class="dropdown-item" href="{{ $button['url'] }}"
                                @if (isset($button['target'])) target="{{ $button['target'] }}" @endif>
                                <i class="{{ $button['icon'] }} me-2"></i>
                                {{ $button['title'] }}
                            </a>
                        @else
                            <button class="dropdown-item"
                                x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                                <i class="{{ $button['icon'] }} me-2"></i>
                                {{ $button['title'] }}
                            </button>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    @else
        {{-- Show all buttons individually when ≤ 3 buttons --}}
        @foreach ($buttons as $button)
            @if ($button['type'] === 'link')
                <a class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" href="{{ $button['url'] }}"
                    @if (isset($button['target'])) target="{{ $button['target'] }}" @endif
                    title="{{ $button['title'] }}">
                    <i class="{{ $button['icon'] }}"></i>
                </a>
            @else
                <button class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" title="{{ $button['title'] }}"
                    x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                    <i class="{{ $button['icon'] }}"></i>
                </button>
            @endif
        @endforeach
    @endif
</div>
