@php
    // Build buttons array based on your existing conditions
    $buttons = [];

    // Restore Button (for deleted agents)
    if ($data->deleted_at != null) {
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.restore'),
            'icon' => 'tf-icons ti ti-rotate-clockwise',
            'class' => 'btn-text-secondary',
            'action' => 'restoreAlert',
            'data' => ['id' => $data->id],
        ];
    }

    // Active agent buttons (when not deleted)
    if ($data->deleted_at == null) {
        // Edit Button
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.edit'),
            'icon' => 'tf-icons ti ti-pencil',
            'class' => 'btn-text-secondary',
            'action' => 'editUser',
            'data' => ['id' => $data->id],
        ];

        // Set Revenue Percent Button
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.set_revenue_percent'),
            'icon' => 'tf-icons ti ti-exchange',
            'class' => 'btn-text-secondary',
            'action' => 'SetRevenuePercent',
            'data' => ['id' => $data->id],
        ];

        // Delete Button
        $buttons[] = [
            'type' => 'button',
            'title' => __('actions.delete'),
            'icon' => 'tf-icons ti ti-trash',
            'class' => 'btn-text-secondary',
            'action' => 'deleteAlert',
            'data' => ['id' => $data->id],
        ];

        // Out Transfers Link
        $buttons[] = [
            'type' => 'link',
            'url' => route('transfers.OutTransfers', $data->id),
            'title' => __('actions.out_transfers'),
            'icon' => 'tf-icons ti ti-upload',
            'class' => 'btn-text-secondary',
            'target' => '_blank',
        ];

        // In Transfers Link
        $buttons[] = [
            'type' => 'link',
            'url' => route('transfers.InTransfers', $data->id),
            'title' => __('actions.in_transfers'),
            'icon' => 'tf-icons ti ti-download',
            'class' => 'btn-text-secondary',
            'target' => '_blank',
        ];
        $buttons[] = [
            'type' => 'link',
            'url' => route('agents.branches', $data->id),
            'title' => __('agents.branches'),
            'icon' => 'tf-icons ti ti-building',
            'class' => 'btn-text-secondary',
            'target' => '_blank',
        ];
        $buttons[] = [
            'type' => 'link',
            'url' => route('users.agent', $data->id),
            'title' => __('agents.users'),
            'icon' => 'tf-icons ti ti-users',
            'class' => 'btn-text-secondary',
            'target' => '_blank',
        ];
    }

    $buttonCount = count($buttons);
    $showDropdown = $buttonCount > 3; // Show dropdown if more than 3 buttons
@endphp

<div class="d-flex justify-content-around align-items-center">
    @if ($showDropdown)
        {{-- Show first 2 buttons + dropdown for remaining --}}
        @foreach (array_slice($buttons, 0, 2) as $button)
            @if ($button['type'] === 'link')
                <a class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" href="{{ $button['url'] }}"
                    @if (isset($button['target'])) target="{{ $button['target'] }}" @endif
                    title="{{ $button['title'] }}">
                    <i class="{{ $button['icon'] }}"></i>
                </a>
            @else
                <button class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" title="{{ $button['title'] }}"
                    x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                    <i class="{{ $button['icon'] }}"></i>
                </button>
            @endif
        @endforeach

        {{-- Dropdown for remaining buttons --}}
        <div class="dropdown d-inline-block">
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" type="button" data-bs-toggle="dropdown"
                aria-expanded="false" title="{{ __('More Actions') }}">
                <i class="tf-icons ti ti-dots-vertical"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                @foreach (array_slice($buttons, 2) as $button)
                    <li>
                        @if ($button['type'] === 'link')
                            <a class="dropdown-item" href="{{ $button['url'] }}"
                                @if (isset($button['target'])) target="{{ $button['target'] }}" @endif>
                                <i class="{{ $button['icon'] }} me-2"></i>
                                {{ $button['title'] }}
                            </a>
                        @else
                            <button class="dropdown-item"
                                x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                                <i class="{{ $button['icon'] }} me-2"></i>
                                {{ $button['title'] }}
                            </button>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    @else
        {{-- Show all buttons individually when ≤ 3 buttons --}}
        @foreach ($buttons as $button)
            @if ($button['type'] === 'link')
                <a class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" href="{{ $button['url'] }}"
                    @if (isset($button['target'])) target="{{ $button['target'] }}" @endif
                    title="{{ $button['title'] }}">
                    <i class="{{ $button['icon'] }}"></i>
                </a>
            @else
                <button class="btn btn-sm {{ $button['class'] }} rounded-pill btn-icon" title="{{ $button['title'] }}"
                    x-on:click="$dispatch('{{ $button['action'] }}', {{ json_encode($button['data']) }})">
                    <i class="{{ $button['icon'] }}"></i>
                </button>
            @endif
        @endforeach
    @endif

    {{-- Toggle Switch - Always visible, not in dropdown --}}
    @if ($data->deleted_at == null)
        @php
            $isChecked = $data->is_active == 1 ? true : false;
        @endphp
        <div x-data="{ checked: {{ $isChecked ? 'true' : 'false' }} }">
            <label class="switch">
                <input type="checkbox" x-model="checked"
                    @change="window.Livewire.dispatch('DisableAgentToggle', {
                        value: '{{ $data->id }}',
                        checked: checked
                    })"
                    class="switch-input is-valid">
                <span class="switch-toggle-slider">
                    <span class="switch-on">on</span>
                    <span class="switch-off">off</span>
                </span>
                <span class="switch-label"
                    x-text="checked ? '{{ __('general.disable') }}' : '{{ __('general.enable') }}'"></span>
            </label>
        </div>
    @endif
</div>
