<div class="d-flex justify-content-around">
    @if ($type == 'out')

        @if (!$data->isDelivered() && !$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted')
            <a class="btn btn-sm btn-text-secondary rounded-pill btn-icon" href="/Transfer/{{ $data->id }}/edit"
                title="{{ __('actions.Edit') }}">
                <i class="tf-icons ti ti-pencil"></i>
            </a>
        @endif


        @if (!$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted')
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.ShowReceipt') }}"
                x-on:click="$dispatch('ShowTransferReceipt', { transfer_id: '{{ $data->id }}' })">
                <i class="tf-icons ti ti-eye"></i>
            </button>
        @endif
        @if (!$data->isDelivered() && !$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted')
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.cancel') }}"
                x-on:click=" $dispatch('CancelTransferConfirm', { transfer_id: '{{ $data->id }}' })">
                <i class="tf-icons ti ti-circle-x"></i>
            </button>
        @endif
    @endif
    @if ($type == 'in')

        @if (!$data->isDelivered() && !$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted')
            <a class="btn btn-sm btn-text-secondary rounded-pill btn-icon" href="/Transfers/Deliver/{{ $data->id }}"
                title="{{ __('actions.DeliverTransfer') }}">
                <i class="tf-icons ti ti-send-2"></i>
            </a>
        @endif

    @endif

    @if ($type == 'collect' && $data->is_collected == 0)
        <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.collect_transfer') }}"
            x-on:click=" $dispatch('ConfirmMessage', { transfer_id: '{{ $data->id }}' ,'emit': 'CollectTransfer'})">
            <i class="tf-icons ti ti-coin"></i>
        </button>
    @endif
    @if ($type == 'pay' && $data->is_paid == 0)
        <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.pay transfer') }}"
            x-on:click=" $dispatch('ConfirmMessage', { transfer_id: '{{ $data->id }}','emit': 'PayTransfer' })">
            <i class="tf-icons ti ti-coin"></i>
        </button>
    @endif
</div>
