@extends('layouts/AgentLayoutMaster')

@section('title', ' Dashboard - Apps')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss'])

    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

@section('page-style')
    @vite('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss')

    <style>
        .page {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ticker-container {
            display: flex;
            align-items: center;
            direction: rtl;
            margin: 0;
            padding: 0;
            width: 100%;
            /* Make it full width */
            background: white;
            /* Match the ticker background */
            box-sizing: border-box;
            /* Prevent padding from breaking layout */
        }

        .tickernews {
            flex: 1;
            /* Take remaining space */
            background: white;
            color: black;
            overflow: hidden;
            white-space: nowrap;
            padding: 10px;
            display: flex;
            align-items: center;
            direction: rtl;
        }

        .news {
            display: inline-block;
            animation: scroll 15s linear infinite;
        }

        .news span {
            margin-right: 40px;
        }

        .tickernews:hover .news {
            animation-play-state: paused;
        }

        @keyframes scroll {
            from {
                transform: translateX(-100%);
            }

            to {
                transform: translateX(100%);
            }
        }
    </style>
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('page-script')

@endsection

@section('content')
    <div class="row g-6">
        @livewire('agent-panel.dashboard.statistics')
        @livewire('agent-panel.dashboard')


        @livewire('transfers.show-transfer-receipt')
    </div>

@endsection
