'use strict';
(function () {
  window.printReceipt = function () {
    const printContents = document.getElementById('receipt-content').innerHTML;
    const originalContents = document.body.innerHTML;
    document.body.innerHTML = printContents;
    window.print();
    document.body.innerHTML = originalContents;
    location.reload();
  };
  document.addEventListener('DOMContentLoaded', function () {
    // This will attach the click event after table is drawn
    $(document).on('click', '.new_transfer_btn', function () {
      Livewire.dispatch('newTransfer');
    });
  });
  window.downloadPDF = function () {
    const element = document.getElementById('receipt-content');
    const opt = {
      margin: 0.5,
      filename: 'transfer-receipt.pdf',
      image: { type: 'jpeg', quality: 0.98 },
      html2canvas: { scale: 2 },
      jsPDF: { unit: 'in', format: 'a4', orientation: 'portrait' }
    };
    html2pdf().set(opt).from(element).save();
  };

  window.captureImage = function () {
    html2canvas(document.getElementById('receipt-content')).then(canvas => {
      const link = document.createElement('a');
      link.download = 'receipt.png';
      link.href = canvas.toDataURL();
      link.click();
    });
  };
  window.captureImageToClipboard = function () {
    const ClipboardItem = window.ClipboardItem || window.WebKitClipboardItem;

    if (!ClipboardItem || !navigator.clipboard || !navigator.clipboard.write) {
      alert('متصفحك لا يدعم نسخ الصور إلى الحافظة');
      return;
    }

    const element = document.getElementById('receipt-content');

    html2canvas(element).then(canvas => {
      canvas.toBlob(blob => {
        const item = new ClipboardItem({ 'image/png': blob });

        navigator.clipboard
          .write([item])
          .then(() => {
            alert('✅ تم نسخ الصورة إلى الحافظة');
          })
          .catch(err => {
            console.error(err);
            alert('❌ فشل في نسخ الصورة إلى الحافظة');
          });
      });
    });
  };

  window.shareReceipt = function () {
    html2canvas(document.getElementById('receipt-content')).then(canvas => {
      canvas.toBlob(blob => {
        const file = new File([blob], 'receipt.png', { type: 'image/png' });

        if (navigator.canShare && navigator.canShare({ files: [file] })) {
          navigator.share({
            files: [file],
            title: 'إشعار التحويل',
            text: 'يرجى مراجعة إشعار التحويل المرفق.'
          });
        } else {
          alert('جهازك لا يدعم ميزة المشاركة.');
        }
      });
    });
  };
})();
