import $ from 'jquery';
window.$ = $;
window.jQuery = $;

import 'jQuery-QueryBuilder/dist/js/query-builder.js';
import 'jQuery-QueryBuilder/dist/css/query-builder.default.css';
let builderInitialized = false;

document.addEventListener('DOMContentLoaded', function () {
  const $builder = $('#builder');

  if ($builder.length && typeof $.fn.queryBuilder === 'function') {
    $builder.queryBuilder({
      filters: [{ id: 'name', label: 'Name', type: 'string' }]
    });
  } else {
    console.error('QueryBuilder plugin did not initialize.');
    console.log('builder found:', $builder.length);
    console.log('queryBuilder loaded:', typeof $.fn.queryBuilder);
  }
});

$('#save_rules').on('click', function () {
  alert('yes');
  let rules = $('#builder').queryBuilder('getRules');

  Livewire.dispatch('saveRules', { rulesJson: JSON.stringify(rules) });
});
window.addEventListener('loadBuilderRules', event => {
  const rules = event.detail.payload;

  if (!builderInitialized) {
    $('#builder').queryBuilder({
      plugins: ['bt-tooltip-errors'],
      filters: [
        { id: 'amount', label: 'Amount', type: 'double' },
        { id: 'currency', label: 'Currency', type: 'string' },
        { id: 'name', label: 'Name', type: 'string' }
      ]
    });
    builderInitialized = true;
  }

  try {
    $('#builder').queryBuilder('setRules', rules);
  } catch (e) {
    console.error('Invalid rules format:', e, rules);
  }
});
