/**
 *  Form Wizard
 */

'use strict';

(function () {
  // Init custom option check
  window.Helpers.initCustomOptionCheck();
  let RentCollectionLast12Monthschart;
  let distributionChart;
  var dt_portfolio_table = $('#portfolio-table');

  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $('body').on('click', '.Portfolio_delete', function (e) {
    e.preventDefault();
    var portfolio_id = $(this).data('id');
    var title = $(this).data('title') || 'Delete Portfolio';
    var text = $(this).data('text') || "You won't be able to revert this!";
    var confirmButtonText = $(this).data('confirm-button-text') || 'Yes, delete it!';
    var cancelButtonText = $(this).data('cancel-button-text') || 'No, cancel!';

    Swal.fire({
      title: title,
      text: text,
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: confirmButtonText,
      customClass: {
        confirmButton: 'btn btn-primary me-3',
        cancelButton: 'btn btn-label-secondary'
      },
      buttonsStyling: false
    }).then(function (result) {
      if (result.value) {
        $.ajax({
          url: '/Portfolio-list/' + portfolio_id,
          type: 'DELETE',
          data: {
            _token: $('meta[name="csrf-token"]').attr('content'),
            portfolio_id: portfolio_id
          },
          success: function (response) {
            if (response.success == true) {
              Swal.fire({
                icon: 'success',
                text: response.msg,
                customClass: {
                  confirmButton: 'btn btn-success'
                }
              });
              dt_portfolio_table.DataTable().ajax.reload();
            }
            if (response.status == 'error') {
              Swal.fire({
                icon: 'error',
                text: response.message,
                customClass: {
                  confirmButton: 'btn btn-danger'
                }
              });
            }
          }
        });
      }
    });
  });
  $('body').on('click', '.portfolio_status', function (e) {
    e.preventDefault();
    var portfolio_id = $(this).data('id');
    var status = $(this).is(':checked') ? 1 : 0;
    $.ajax({
      url: '/Portfolio/Portfolio-updateStatus/' + portfolio_id,
      type: 'GET',
      data: {
        _token: $('meta[name="csrf-token"]').attr('content'),
        portfolio_id: portfolio_id,
        status: status
      },
      success: function (response) {
        if (response.success == true) {
          Swal.fire({
            icon: 'success',
            text: response.msg,
            customClass: {
              confirmButton: 'btn btn-success'
            }
          });
          dt_portfolio_table.DataTable().ajax.reload();
        }
        if (response.status == 'error') {
          Swal.fire({
            icon: 'error',
            text: response.message,
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      }
    });
  });
  window.addEventListener('RentCollectionLast12MonthsDataUpdated', function (event) {
    if (RentCollectionLast12Monthschart) RentCollectionLast12Monthschart.destroy();

    const data = event.detail[0].data;
    console.log(data);

    RentCollectionLast12Monthschart = new ApexCharts(document.querySelector('#RentCollectionLast12Monthschart'), {
      chart: {
        type: 'bar',
        stacked: true,
        height: 400,
        toolbar: { show: false }
      },
      series: data.series, // Now contains both 'Invoiced' and 'Paid'
      xaxis: {
        categories: data.labels
      },
      colors: ['#FFB347', '#00C49F'], // Invoiced: orange, Paid: green
      plotOptions: {
        bar: {
          columnWidth: '45%',
          borderRadius: 4,
          dataLabels: { position: 'top' },
          grouped: true
        }
      },
      tooltip: {
        y: {
          formatter: val => `₺${val.toLocaleString()}`
        }
      },
      legend: {
        position: 'top',
        horizontalAlign: 'right',
        labels: {
          colors: '#333'
        }
      }
    });

    RentCollectionLast12Monthschart.render();
  });

  window.addEventListener('update-distribution-chart', event => {
    const chartData = event.detail[0];

    if (!distributionChart) {
      distributionChart = new ApexCharts(document.querySelector('#distribution-chart'), {
        chart: {
          type: 'bar',
          height: 400,
          stacked: true,
          toolbar: {
            show: true
          },
          zoom: {
            enabled: true
          }
        },

        responsive: [
          {
            breakpoint: 480,
            options: {
              legend: {
                position: 'bottom',
                offsetX: -10,
                offsetY: 0
              }
            }
          }
        ],
        plotOptions: {
          bar: {
            horizontal: false,
            columnWidth: '60%'
          }
        },
        dataLabels: {
          enabled: true
        },
        series: chartData.series,
        xaxis: {
          categories: chartData.categories
        },

        colors: ['#007bff', '#28a745', '#ffc107']
      });

      distributionChart.render();
    } else {
      console.log(chartData);
      distributionChart.updateOptions({
        chart: {
          type: 'bar',
          height: 400,
          stacked: true,
          toolbar: {
            show: true
          },
          zoom: {
            enabled: true
          }
        },

        responsive: [
          {
            breakpoint: 480,
            options: {
              legend: {
                position: 'bottom',
                offsetX: -10,
                offsetY: 0
              }
            }
          }
        ],
        plotOptions: {
          bar: {
            horizontal: false,
            columnWidth: '60%'
          }
        },
        dataLabels: {
          enabled: true
        },
        series: chartData.series,
        xaxis: {
          categories: chartData.categories
        },

        colors: ['#007bff', '#28a745', '#ffc107']
      });
    }
  });

  window.addEventListener('PorfolioFinancialBreakdownByPropertyDataUpdated', function (event) {
    if (RentCollectionLast12Monthschart) RentCollectionLast12Monthschart.destroy();

    const data = event.detail[0].data;
    console.log(data);
    RentCollectionLast12Monthschart = new ApexCharts(document.querySelector('#RentCollectionLast12Monthschart'), {
      chart: {
        type: 'bar',
        height: 400,
        stacked: true,
        toolbar: { show: false }
      },
      plotOptions: {
        bar: {
          horizontal: false,
          borderRadius: 4,
          columnWidth: '50%'
        }
      },
      dataLabels: {
        enabled: false
      },
      stroke: {
        show: true,
        width: 1,
        colors: ['#fff']
      },
      xaxis: {
        categories: data.labels, // populated dynamically
        labels: {
          rotate: -45,
          style: { fontSize: '12px' }
        }
      },
      yaxis: {
        title: {
          text: '₺ Amount'
        }
      },
      tooltip: {
        y: {
          formatter: val => `₺${val.toLocaleString()}`
        }
      },
      legend: {
        position: 'top',
        horizontalAlign: 'center'
      },
      fill: {
        opacity: 1
      },
      colors: ['#00b894', '#0984e3', '#d63031'], // rent, paid, pending
      series: data.series // populated dynamically
    });

    RentCollectionLast12Monthschart.render();
  });
  window.addEventListener('PropertyQualificationChartUpdated', function (event) {
    const data = event.detail[0].data;

    if (window.qualificationChart) window.qualificationChart.destroy();

    window.qualificationChart = new ApexCharts(document.querySelector('#PropertyQualificationChart'), {
      chart: {
        type: 'donut', // or 'pie'
        height: 350
      },
      labels: data.labels,
      series: data.series,
      legend: {
        position: 'bottom'
      },
      tooltip: {
        y: {
          formatter: val => `${val} ${val === 1 ? 'property' : 'properties'}`
        }
      }
    });

    window.qualificationChart.render();
  });

  window.addEventListener('update-occupancy-chart', function (event) {
    const data = event.detail[0].data;

    window.occupancyChart = new ApexCharts(document.querySelector('#occupancyChart'), {
      chart: {
        type: 'donut',
        height: 300
      },
      labels: data.labels,
      series: data.series,
      colors: ['#00b894', '#d63031'],
      legend: {
        position: 'bottom'
      },
      tooltip: {
        y: {
          formatter: val => `${val} ${val === 1 ? 'property' : 'properties'}`
        }
      }
    });

    window.occupancyChart.render();
  });
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];

    const table = window.LaravelDataTables['portfolio-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
})();
