var theme = $('html').hasClass('light-style') ? 'default' : 'default-dark';
var type = $('#jstree-type-container').data('type');
var table_id = $('#jstree-container').data('table');
(function () {
  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }
  let CategoryChart;
  let DonationStatisticsChart;
  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };
  $('#jstree-type-container').jstree({
    plugins: ['checkbox', 'search', 'types'],
    types: {
      default: {
        icon: 'ti ti-folder'
      }
    },
    checkbox: {
      keep_selected_style: true,
      three_state: false, // Only check what you select (not parent-child propagation)
      cascade: 'none' // Prevent auto-checking children or parents
    },
    core: {
      themes: {
        name: theme
      },
      data: [
        {
          id: 'conditional',
          text: 'Conditional',
          value: 'conditional'
        },
        {
          id: 'unconditional',
          text: 'Unconditional',
          value: 'unconditional',
          state: { opened: true }
        }
      ]
    },
    search: {
      show_only_matches: true,
      show_only_matches_children: true // optional: shows children of matched nodes
    }
  });

  $('#jstree-type-container').on('changed.jstree', function (e, data) {
    const selectedNodes = data.selected;

    window.selectedDonationTypes = [];

    selectedNodes.forEach(id => {
      window.selectedDonationTypes.push(id);
    });

    $('#' + table_id)
      .DataTable()
      .ajax.reload();
  });
  window.addEventListener('DonationChartDataUpdated', function (event) {
    var series = event.detail[0].data;
    var categories = event.detail[0].categories;

    InitDonationsChart(series, categories);
  });
  window.addEventListener('initCategoryChart', function (event) {
    var series = event.detail[0].series;
    var labels = event.detail[0].labels;
    initCategoryChart(labels, series);
  });
  function InitDonationsChart(series, categories) {
    console.log('Donation Chart Data:', series);

    const maxValue = Math.max(...series[0].data);
    const yAxisMax = Math.ceil((maxValue * 1.2) / 1000) * 1000;

    const shipmentEl = document.querySelector('#DonationStatisticsChart');
    const shipmentConfig = {
      series: series,
      chart: {
        height: 320,
        type: 'area',
        stacked: false,
        parentHeightOffset: 0,
        toolbar: { show: false },
        zoom: { enabled: false }
      },
      markers: {
        size: 5,
        colors: [config.colors.white],
        strokeColors: chartColors.line.series2,
        hover: { size: 6 },
        borderRadius: 4
      },
      stroke: {
        curve: 'smooth',
        width: [0, 3],
        lineCap: 'round'
      },
      legend: {
        show: true,
        position: 'bottom',
        markers: {
          width: 8,
          height: 8,
          offsetX: -3
        },
        height: 40,
        itemMargin: {
          horizontal: 10,
          vertical: 0
        },
        fontSize: '15px',
        fontFamily: 'Public Sans',
        fontWeight: 400,
        labels: {
          colors: headingColor,
          useSeriesColors: false
        },
        offsetY: 10
      },
      grid: {
        strokeDashArray: 8,
        borderColor
      },
      colors: [chartColors.line.series1, chartColors.line.series2],
      fill: {
        opacity: [1, 1]
      },
      dataLabels: { enabled: false },
      xaxis: {
        tickAmount: 10,
        categories: categories,
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontWeight: 400
          }
        },
        axisBorder: { show: false },
        axisTicks: { show: false }
      },
      yaxis: {
        min: 0,
        max: yAxisMax,
        tickAmount: 5,
        labels: {
          formatter: function (val) {
            return val.toLocaleString() + ' ₺';
          }
        }
      },
      responsive: [
        /* unchanged responsive config */
      ]
    };

    if (!DonationStatisticsChart) {
      DonationStatisticsChart = new ApexCharts(shipmentEl, shipmentConfig);
      DonationStatisticsChart.render();
    } else {
      DonationStatisticsChart.updateOptions(shipmentConfig);
    }
  }
  function initCategoryChart(labels, series) {
    // Reasons for delivery exceptions Chart
    // --------------------------------------------------------------------
    const deliveryExceptionsChartE1 = document.querySelector('#deliveryExceptionsChart'),
      deliveryExceptionsChartConfig = {
        chart: {
          height: 420,
          parentHeightOffset: 0,
          type: 'donut'
        },
        labels: labels,
        series: series,
        colors: [
          chartColors.donut.series1,
          chartColors.donut.series2,
          chartColors.donut.series3,
          chartColors.donut.series4
        ],
        stroke: {
          width: 0
        },
        dataLabels: {
          enabled: false,
          formatter: function (val, opt) {
            return parseInt(val);
          }
        },
        legend: {
          show: true,
          position: 'bottom',
          offsetY: 10,
          markers: {
            width: 8,
            height: 8,
            offsetX: -3
          },
          itemMargin: {
            horizontal: 15,
            vertical: 5
          },
          fontSize: '13px',
          fontFamily: 'Public Sans',
          fontWeight: 400,
          labels: {
            colors: headingColor,
            useSeriesColors: false
          }
        },
        tooltip: {
          theme: false
        },
        grid: {
          padding: {
            top: 15
          }
        },
        plotOptions: {
          pie: {
            donut: {
              size: '77%',
              labels: {
                show: true,
                value: {
                  fontSize: '24px',
                  fontFamily: 'Public Sans',
                  color: headingColor,
                  fontWeight: 500,
                  offsetY: -20,
                  formatter: function (val) {
                    return parseInt(val);
                  }
                },
                name: {
                  offsetY: 30,
                  fontFamily: 'Public Sans'
                },
                total: {
                  show: true,
                  fontSize: '15px',
                  fontFamily: 'Public Sans',
                  color: legendColor,

                  formatter: function (w) {
                    return parseInt(w.globals.seriesTotals.reduce((a, b) => a + b, 0));
                  }
                }
              }
            }
          }
        },
        responsive: [
          {
            breakpoint: 420,
            options: {
              chart: {
                height: 360
              }
            }
          }
        ]
      };
    if (!CategoryChart) {
      CategoryChart = new ApexCharts(deliveryExceptionsChartE1, deliveryExceptionsChartConfig);
      CategoryChart.render();
    } else {
      CategoryChart.updateOptions(deliveryExceptionsChartConfig);
    }
  }
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];

    const table = window.LaravelDataTables['donation-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
})();
