<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ReasonSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'name' => ['ar' => 'الراتب', 'en' => 'Salary', 'tr' => 'Maaş'],
            ],
            [
                'name' => ['ar' => 'السلفة', 'en' => 'Advance Payment', 'tr' => 'Avans'],
            ],
            [
                'name' => ['ar' => 'الإيجار', 'en' => 'Rent', 'tr' => 'Kira'],
            ],
            [
                'name' => ['ar' => 'المصاريف التشغيلية', 'en' => 'Operational Expenses', 'tr' => 'Operasyonel Giderler'],
            ],
            [
                'name' => ['ar' => 'الرسوم', 'en' => 'Fees', 'tr' => 'Ücret'],
            ],
            [
                'name' => ['ar' => 'الفواتير', 'en' => 'Bills', 'tr' => 'Faturalar'],
            ],
            [
                'name' => ['ar' => 'التحويل العائلي', 'en' => 'Family Transfer', 'tr' => 'Aile Transferi'],
            ],
            [
                'name' => ['ar' => 'الدعم', 'en' => 'Support', 'tr' => 'Destek'],
            ],
            [
                'name' => ['ar' => 'التبرع', 'en' => 'Donation', 'tr' => 'Bağış'],
            ],
            [
                'name' => ['ar' => 'سداد القرض', 'en' => 'Loan Repayment', 'tr' => 'Kredi Geri Ödeme'],
            ],
            [
                'name' => ['ar' => 'التمويل', 'en' => 'Financing', 'tr' => 'Finansman'],
            ],
            [
                'name' => ['ar' => 'الشراء', 'en' => 'Purchase', 'tr' => 'Satın Alma'],
            ],
            [
                'name' => ['ar' => 'التسوية', 'en' => 'Settlement', 'tr' => 'Mutabakat'],
            ],
            [
                'name' => ['ar' => 'العقوبات', 'en' => 'Penalty', 'tr' => 'Ceza'],
            ],
            [
                'name' => ['ar' => 'التخلفات', 'en' => 'Violation', 'tr' => 'Taklif'],
            ],
        ];

        foreach ($data as $reason) {
            \App\Models\Reason::create($reason);
        }
    }
}
