<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Abivia\Ledger\Http\Controllers\LedgerAccountController;
use Abivia\Ledger\Messages\Account;
use Abivia\Ledger\Messages\Balance;
use Abivia\Ledger\Messages\Create;
use Abivia\Ledger\Messages\Currency;
use Abivia\Ledger\Messages\Name;
use Carbon\Carbon;

class LedgerChartSeeder extends Seeder
{
  public function run()
  {
    $create = new Create();

    // Set ledger name(s)
    $create->names[] = Name::fromArray([
      'name' => 'Global Money Transfer Ledger',
      'language' => 'en',
    ]);

    // Define currencies you want to support
    $create->currencies[] = Currency::fromArray(['code' => 'USD', 'decimals' => 2]);
    $create->currencies[] = Currency::fromArray(['code' => 'TRY', 'decimals' => 2]);
    $create->currencies[] = Currency::fromArray(['code' => 'SYP', 'decimals' => 0]);

    // Define accounts - use codes meaningful to your domain
    $accounts = [
      ['code' => '1000', 'debit' => true, 'name' => 'Assets'],
      ['code' => '1100', 'debit' => true, 'name' => 'Cash', 'parent' => '1000'],
      ['code' => '1110', 'debit' => true, 'name' => 'Agent Cash', 'parent' => '1100'],

      ['code' => '2000', 'credit' => true, 'name' => 'Liabilities'],

      ['code' => '3000', 'credit' => true, 'name' => 'Income'],
      ['code' => '3100', 'credit' => true, 'name' => 'Transfer Fees', 'parent' => '3000'],

      ['code' => '4000', 'debit' => true, 'name' => 'Expenses'],
      ['code' => '4100', 'debit' => true, 'name' => 'Agent Commission', 'parent' => '4000'],
    ];
    foreach ($accounts as $account) {
      $create->accounts[] = Account::fromArray($account);
    }

    // Opening balances - set zero initially or as you see fit
    $create->balances[] = Balance::fromArray([
      'code' => '1000',
      'amount' => '0',
      'currency' => 'USD'
    ]);
    $create->balances[] = Balance::fromArray([
      'code' => '2000',
      'amount' => '0',
      'currency' => 'USD'
    ]);
    $create->balances[] = Balance::fromArray([
      'code' => '3000',
      'amount' => '0',
      'currency' => 'USD'
    ]);
    $create->balances[] = Balance::fromArray([
      'code' => '4000',
      'amount' => '0',
      'currency' => 'USD'
    ]);

    // Set the ledger opening date (use your system start date)
    $create->transDate = Carbon::now();

    // Create the ledger and accounts in one go
    $accountController = new LedgerAccountController();
    $response = $accountController->create($create);

    if ($response->status !== 'ok') {
      $this->command->error('Failed to create ledger accounts: ' . json_encode($response->messages));
    } else {
      $this->command->info('Ledger base chart of accounts created successfully.');
    }
  }
}
