<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Carbon\Carbon;
use Abivia\Ledger\Http\Controllers\LedgerAccountController;
use Abivia\Ledger\Messages\Account;
use Abivia\Ledger\Messages\Balance;
use Abivia\Ledger\Messages\Create;
use Abivia\Ledger\Messages\Currency;
use Abivia\Ledger\Messages\Name;
use Abivia\Ledger\Exceptions\Breaker;
use Exception;

class LedgerAndAgentsSeeder extends Seeder
{
    public function run(): void
    {
        $create = new Create();

        // Ledger name
        $create->names[] = Name::fromArray([
            'name' => 'FastTransfer Inc.'
        ]);

        // Base currency: USD
        $create->currencies[] = Currency::fromArray([
            'code' => 'USD',
            'decimals' => 2
        ]);

        // Ledger start date
        $create->transDate = Carbon::create(2025, 1, 1);

        // Main company cash account
        $create->accounts[] = Account::fromArray([
            'code' => '1000',
            'debit' => true,
            'name' => 'Main Cash Account'
        ]);

        // Commission revenue
        $create->accounts[] = Account::fromArray([
            'code' => '4000',
            'credit' => true,
            'name' => 'Commission Revenue'
        ]);

        // Initial Equity to balance the books
        $create->accounts[] = Account::fromArray([
            'code' => '3000',
            'credit' => true,
            'name' => 'Initial Equity'
        ]);

        // Opening balance: main cash $10,000
        $create->balances[] = Balance::fromArray([
            'code' => '1000',
            'amount' => '10000',
            'currency' => 'USD'
        ]);

        // Matching credit to equity to keep balanced books
        $create->balances[] = Balance::fromArray([
            'code' => '3000',
            'amount' => '-10000',
            'currency' => 'USD'
        ]);

        $accountController = new LedgerAccountController();

        try {
            $accountController->create($create);
            $this->command->info('✅ Main ledger created successfully.');
        } catch (Exception $e) {
            $this->command->error('❌ Ledger creation failed: ' . $e->getMessage());
        }
    }
}
