<?php

namespace Database\Seeders;

use App\Models\IdentityType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class IdentityTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'id' => 1,
                'name' => ['tr' => 'TC', 'ar' => 'البطاقة الشخصية', 'en' => 'ID Card'],
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 2,
                'name' => ['tr' => 'Pasaport', 'ar' => 'جواز سفر', 'en' => 'Passport'],
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 3,
                'name' => ['tr' => 'Ehliyet', 'ar' => 'شهادة القيادة', 'en' => 'Driving License'],
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];
        foreach ($data as $d) {
            IdentityType::create($d);
        }
    }
}
