<?php

namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $data = [

            [
                'id' => 1,
                'name' => ["en" => 'USD', "ar" => 'دولار أمريكي'],
                'code' => 'USD',
                'symbol' => '$',
                'exchange_rate' => 1.0,
                'rate_factor' => 'multiply',
                'is_default' => true,

                'created_at' => now(),
                'updated_at' => now(),
            ],

        ];
        foreach ($data as $d) {
            Currency::create($d);
        }
    }
}
