<?php

namespace Database\Seeders;

use App\Models\ApiType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ApiTypeSeeder extends Seeder
{
    public function run()
    {
        // ApiType::truncate(); // Optional: clear existing

        ApiType::create([
            'name' => 'Orangefer',
            'class_name' => 'App\\Services\\Partners\\OrangeferApi',
            'config_fields' => [
                'username',
                'password',
                'agentcode',
                'base_url'
            ],
        ]);

        ApiType::create([
            'name' => 'Turkuaz',
            'class_name' => 'App\\Services\\Partners\\TurkuazApi',
            'config_fields' => [
                'username',
                'password',
                'key',
                'base_url'
            ],
        ]);
        ApiType::create([
            'name' => 'BestRate',
            'class_name' => 'App\Services\Partners\BestRateApi',
            'config_fields' => [
                'Account',
                'BranchId',
                'UserName',
                'Password',
                'base_url',
                'public_key'
            ],
        ]);
    }
}
