<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        Schema::create('agent_syp_rates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('agent_id')->constrained()->onDelete('cascade');
            $table->string('currency_code', 3); // e.g. USD, EUR, TRY
            $table->boolean('enabled')->default(false);
            $table->decimal('sell_price', 18, 2)->default(0);
            $table->decimal('buy_price', 18, 2)->default(0);
            $table->decimal('buy_price_diff', 15, 2)->nullable(); // difference from sell
            $table->enum('buy_price_mode', ['actual', 'difference'])->default('actual');

            $table->timestamps();

            $table->unique(['agent_id', 'currency_code']); // prevent duplicates
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_syp_rates');
    }
};
