<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Expand ENUM to include reverse and deleted
        DB::statement("
            ALTER TABLE ledger_transfers 
            MODIFY status ENUM(
                'pending', 
                'paid', 
                'received', 
                'cancelled', 
                'completed', 
                'reverse', 
                'deleted'
            ) DEFAULT 'pending'
        ");
    }

    public function down(): void
    {
        // Clean up data before shrinking ENUM
        DB::table('ledger_transfers')
            ->whereNotIn('status', ['pending', 'paid', 'received', 'cancelled', 'completed'])
            ->update(['status' => 'pending']);

        // Now shrink ENUM back
        DB::statement("
            ALTER TABLE ledger_transfers 
            MODIFY status ENUM(
                'pending', 
                'paid', 
                'received', 
                'cancelled', 
                'completed'
            ) DEFAULT 'pending'
        ");
    }
};
