<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('external_agents', function (Blueprint $table) {
            $table->id();
            $table->string('external_id'); // e.g., "123456"
            $table->string('name');
            $table->string('phone')->nullable();
            $table->string('country')->nullable();
            $table->string('currency')->nullable();
            $table->integer('source_id'); // id of  the api_config.
            $table->unsignedBigInteger('agent_id')->nullable(); // if linked to an agent
            $table->boolean('active')->default(true);
            $table->timestamps();

            $table->unique(['external_id', 'source_id']); // prevent duplicates
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('external_agents');
    }
};
